/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class MaxMailSizeTest
extends AbstractMailTest {
    private MailTestManager manager;

    public MaxMailSizeTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = new MailTestManager(this.client, true);
    }

    @Override
    protected void tearDown() throws Exception {
        this.manager.cleanUp();
        super.tearDown();
    }

    public void testSendWithManager() throws OXException, IOException, SAXException, JSONException {
        UserValues values = this.client.getValues();
        TestMail mail = new TestMail();
        mail.setSubject("Test MaxMailSize");
        mail.setFrom(values.getSendAddress());
        mail.setTo(Arrays.asList(values.getSendAddress()));
        mail.setContentType(MailContentType.PLAIN.toString());
        mail.setBody("Test Mail");
        mail.sanitize();
        class FooInputStream
        extends InputStream {
            private final long size;
            private long read = 0L;

            public FooInputStream(long size) {
                this.size = size;
            }

            @Override
            public int read() throws IOException {
                return this.read++ < this.size ? 97 : -1;
            }
        }
        TestMail inSentBox = this.manager.send(mail, new FooInputStream(3500000L));
        MaxMailSizeTest.assertFalse((String)"Sending resulted in error.", (boolean)this.manager.getLastResponse().hasError());
        MaxMailSizeTest.assertEquals((String)"Mail went into inbox", (String)values.getSentFolder(), (String)inSentBox.getFolder());
        mail = new TestMail();
        mail.setSubject("Test MaxMailSize");
        mail.setFrom(values.getSendAddress());
        mail.setTo(Arrays.asList(values.getSendAddress()));
        mail.setContentType(MailContentType.PLAIN.toString());
        mail.setBody("Test Mail");
        mail.sanitize();
        this.manager.setFailOnError(false);
        this.manager.send(mail, new FooInputStream(3800000L));
        MaxMailSizeTest.assertTrue((String)"Should not pass", (boolean)this.manager.getLastResponse().hasError());
        OXException exception = this.manager.getLastResponse().getException();
        MaxMailSizeTest.assertEquals((String)"Wrong exception.", (int)MailExceptionCode.MAX_MESSAGE_SIZE_EXCEEDED.getNumber(), (int)exception.getCode());
    }
}

