/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.actions.NewMailResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug29865Test
extends AbstractMailTest {
    private static String attachment = Bug29865Test.readFile("attachment.base64");
    private static String eml = Bug29865Test.readFile("bug29865.eml");
    private UserValues values;

    public Bug29865Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetStructure() throws OXException, IOException, JSONException {
        NewMailRequest newMailRequest = new NewMailRequest(null, eml.replaceAll("#ADDR#", this.values.getSendAddress()), -1, true);
        NewMailResponse newMailResponse = this.getClient().execute(newMailRequest);
        Bug29865Test.assertNotNull((String)"Missing folder in response.", (Object)newMailResponse.getFolder());
        Bug29865Test.assertNotNull((String)"Missing ID in response.", (Object)newMailResponse.getId());
        GetRequest newGetRequest = new GetRequest(newMailResponse.getFolder(), newMailResponse.getId(), true, true);
        GetResponse newGetResponse = this.getClient().execute(newGetRequest);
        String actualAttachment = ((JSONObject)newGetResponse.getData()).getJSONArray("body").getJSONObject(1).getJSONObject("body").getString("data");
        Bug29865Test.assertEquals((String)"Attachment has been modified", (String)attachment.replaceAll("(\\r|\\n)", ""), (String)actualAttachment);
    }

    private static String readFile(String fileName) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR) + fileName));
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            return sb.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

