/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.AllResponse;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.ajax.mail.actions.SendResponse;
import com.openexchange.mail.MailJSONField;
import com.openexchange.tools.arrays.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public final class Bug27708Test
extends AbstractMailTest {
    private static final int NUM_THREADS = 4;
    private AJAXClient[] clients;
    private String recipient;
    private String[] identifier;
    private List<String[]>[] sentMails;

    public Bug27708Test(String name) {
        super(name);
    }

    @Override
    @BeforeClass
    protected void setUp() throws Exception {
        int i;
        super.setUp();
        this.clients = new AJAXClient[4];
        this.clients[0] = this.getClient();
        this.clients[1] = new AJAXClient(AJAXClient.User.User2);
        this.clients[2] = new AJAXClient(AJAXClient.User.User3);
        this.clients[3] = new AJAXClient(AJAXClient.User.User4);
        this.recipient = this.getClient().getValues().getSendAddress();
        this.identifier = new String[4];
        for (i = 0; i < this.identifier.length; ++i) {
            this.identifier[i] = UUID.randomUUID().toString();
        }
        this.sentMails = new List[4];
        for (i = 0; i < this.sentMails.length; ++i) {
            this.sentMails[i] = new LinkedList<String[]>();
        }
    }

    @Override
    @AfterClass
    protected void tearDown() throws Exception {
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i].execute(new DeleteRequest((String[][])this.sentMails[i].toArray((T[])new String[this.sentMails[i].size()][]), true));
        }
        String inboxFolder = this.getClient().getValues().getInboxFolder();
        AllRequest request = new AllRequest(inboxFolder, new int[]{600}, -1, null, true);
        AllResponse response = this.getClient().execute(request);
        String[][] folderAndIDs = new String[response.size()][2];
        for (int i = 0; i < response.size(); ++i) {
            folderAndIDs[i] = new String[]{inboxFolder, (String)response.getValue(i, 600)};
        }
        this.getClient().execute(new DeleteRequest(folderAndIDs, true));
        if (null != this.clients) {
            for (AJAXClient client : this.clients) {
                if (null == client) continue;
                client.logout();
            }
            this.clients = null;
        }
        super.tearDown();
    }

    @Test
    public void testBug27708() throws Exception {
        Thread[] threads = new Thread[this.clients.length];
        MailSender[] senders = new MailSender[this.clients.length];
        for (int i = 0; i < this.clients.length; ++i) {
            senders[i] = new MailSender(this.clients[i], this.recipient, this.identifier[i], (String[])Arrays.remove((Object[])this.identifier, (Object[])new String[]{this.identifier[i]}), this.sentMails[i]);
            threads[i] = new Thread(senders[i]);
            threads[i].start();
        }
        int running = 0;
        do {
            running = 0;
            for (int i = 0; i < threads.length; ++i) {
                if (!threads[i].isAlive()) continue;
                ++running;
            }
            Thread.sleep(100L);
        } while (running > true);
        for (MailSender sender : senders) {
            sender.stop();
        }
        for (int i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        StringBuilder sb = new StringBuilder();
        for (MailSender sender : senders) {
            Throwable t = sender.getThrowable();
            if (null == t) continue;
            sb.append(t.getMessage());
            sb.append('\n');
        }
        Assert.assertTrue((String)sb.toString(), (0 == sb.length() ? 1 : 0) != 0);
    }

    private static final class MailSender
    implements Runnable {
        private static final boolean DRAFT = false;
        private final AJAXClient client;
        private final String recipient;
        private final String identifier;
        private final String[] others;
        private final List<String[]> mails;
        private boolean running = true;
        private Throwable throwable;

        MailSender(AJAXClient client, String recipient, String identifier, String[] others, List<String[]> mails) {
            this.recipient = recipient;
            this.identifier = identifier;
            this.client = client;
            this.others = others;
            this.mails = mails;
        }

        public void stop() {
            this.running = false;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public void run() {
            try {
                for (int j = 0; j < 1000 && this.running; ++j) {
                    JSONObject json = AbstractMailTest.createEMail(this.client, this.recipient, "Test Bug 27708", "TEXT/HTML", "<html><body style=\\u0022\\u0022><div>" + this.identifier + "</div></body></html>");
                    SendRequest sendRequest = new SendRequest(json.toString());
                    SendResponse response = this.client.execute(sendRequest);
                    String[] folderAndID = response.getFolderAndID();
                    this.mails.add(folderAndID);
                    GetResponse getResponse = this.client.execute(new GetRequest(folderAndID[0], folderAndID[1]));
                    JSONArray attachments = getResponse.getAttachments();
                    JSONObject tmp = attachments.getJSONObject(0);
                    String body = tmp.getString(MailJSONField.CONTENT.getKey());
                    Assert.assertTrue((String)("Sent mail does not contain senders mail body.\n" + body), (boolean)body.contains(this.identifier));
                    for (String other : this.others) {
                        Assert.assertFalse((String)("Sent mail does contain others mail body.\n" + body), (boolean)body.contains(other));
                    }
                }
            }
            catch (Exception e) {
                this.throwable = e;
            }
            catch (AssertionError e) {
                this.throwable = e;
            }
        }
    }
}

