/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.ForwardRequest;
import com.openexchange.ajax.mail.actions.ForwardResponse;
import com.openexchange.ajax.mail.actions.ReplyAllRequest;
import com.openexchange.ajax.mail.actions.ReplyAllResponse;
import com.openexchange.ajax.mail.actions.ReplyRequest;
import com.openexchange.ajax.mail.actions.ReplyResponse;
import com.openexchange.exception.OXException;
import com.openexchange.test.ContactTestManager;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public abstract class AbstractReplyTest
extends AbstractMailTest {
    protected ContactTestManager contactManager;

    public AbstractReplyTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.contactManager = new ContactTestManager(this.client);
    }

    @Override
    protected void tearDown() throws Exception {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.contactManager.cleanUp();
        super.tearDown();
    }

    protected boolean contains(List<String> from, String string) {
        for (String str2 : from) {
            if (!str2.contains(string)) continue;
            return true;
        }
        return false;
    }

    protected JSONObject getReplyEMail(TestMail testMail) throws OXException, IOException, SAXException, JSONException {
        ReplyRequest reply = new ReplyRequest(testMail.getFolder(), testMail.getId());
        reply.setFailOnError(true);
        this.client = this.getClient();
        ReplyResponse response = this.client.execute(reply);
        return (JSONObject)response.getData();
    }

    protected JSONObject getReplyAllEMail(TestMail testMail) throws OXException, IOException, SAXException, JSONException {
        ReplyAllRequest reply = new ReplyAllRequest(testMail.getFolder(), testMail.getId());
        reply.setFailOnError(true);
        this.client = this.getClient();
        ReplyAllResponse response = (ReplyAllResponse)this.client.execute(reply);
        return (JSONObject)response.getData();
    }

    protected JSONObject getForwardMail(TestMail testMail) throws OXException, IOException, SAXException, JSONException {
        ForwardRequest reply = new ForwardRequest(testMail.getFolder(), testMail.getId());
        reply.setFailOnError(true);
        this.client = this.getClient();
        ForwardResponse response = (ForwardResponse)this.client.execute(reply);
        return (JSONObject)response.getData();
    }

    public static void assertNullOrEmpty(String msg, Collection coll) {
        if (coll == null) {
            return;
        }
        if (coll.size() == 0) {
            return;
        }
        AbstractReplyTest.fail((String)msg);
    }
}

