/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.parser.ResponseParser;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;

public abstract class AbstractAJAXParser<T extends AbstractAJAXResponse>
extends Assert {
    private final boolean failOnError;
    private static final int MAX_STACK_TRACE_ELEMENTS = 1000;

    protected AbstractAJAXParser(boolean failOnError) {
        this.failOnError = failOnError;
    }

    protected Response getResponse(String body) throws JSONException {
        OXException exception;
        if (body.startsWith("<!DOCTYPE HTML")) {
            int pos1 = body.indexOf(123);
            int pos2 = body.indexOf("})</script>");
            body = body.substring(pos1, pos2 + 1);
        }
        Response response = ResponseParser.parse((String)body);
        if (this.failOnError && response.hasError() && null != (exception = response.getException())) {
            StringBuilder sb = new StringBuilder(exception.getMessage());
            sb.insert(0, "Request failed with error -- ");
            StackTraceElement[] trace = exception.getStackTrace();
            if (null != trace) {
                String lineSeparator = System.getProperty("line.separator");
                sb.append(lineSeparator);
                AbstractAJAXParser.appendStackTrace(trace, lineSeparator, sb);
            }
            AbstractAJAXParser.assertTrue((String)sb.toString(), (boolean)Category.CATEGORY_WARNING.getType().equals(exception.getCategory().getType()));
        }
        return response;
    }

    public String checkResponse(HttpResponse resp) throws ParseException, IOException {
        AbstractAJAXParser.assertEquals((String)("Response code is not okay. (" + resp.getStatusLine().getReasonPhrase() + ")"), (int)200, (int)resp.getStatusLine().getStatusCode());
        return EntityUtils.toString((HttpEntity)resp.getEntity());
    }

    public T parse(String body) throws JSONException {
        Response response = this.getResponse(body);
        return this.createResponse(response);
    }

    protected abstract T createResponse(Response var1) throws JSONException;

    protected boolean isFailOnError() {
        return this.failOnError;
    }

    private static void appendStackTrace(StackTraceElement[] trace, String lineSeparator, StringBuilder sb) {
        if (null == trace) {
            return;
        }
        int length = 1000 <= trace.length ? 1000 : trace.length;
        for (int i = 0; i < length; ++i) {
            StackTraceElement ste = trace[i];
            String className = ste.getClassName();
            if (null == className) continue;
            sb.append("    at ").append(className).append('.').append(ste.getMethodName());
            if (ste.isNativeMethod()) {
                sb.append("(Native Method)");
            } else {
                String fileName = ste.getFileName();
                if (null == fileName) {
                    sb.append("(Unknown Source)");
                } else {
                    int lineNumber = ste.getLineNumber();
                    sb.append('(').append(fileName);
                    if (lineNumber >= 0) {
                        sb.append(':').append(lineNumber);
                    }
                    sb.append(')');
                }
            }
            sb.append(lineSeparator);
        }
    }
}

