/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.action.AllRequest;
import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.contact.action.ListRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.contact.Data;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import java.util.Date;
import java.util.TimeZone;

public class Bug16618Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private TimeZone tz;
    private Contact contact;
    private int contextId;
    private int contactId;
    private int folderId;

    public Bug16618Test(String name) {
        super(name);
    }

    private Contact createContactWithImage() throws Exception {
        Contact contact = new Contact();
        this.contextId = this.client.getValues().getContextId();
        contact.setTitle("Herr");
        contact.setSurName("Abba");
        contact.setGivenName("Baab");
        contact.setDisplayName("Baab Abba");
        contact.setStreetBusiness("Franz-Meier Weg 17");
        contact.setCityBusiness("Test Stadt");
        contact.setStateBusiness("NRW");
        contact.setCountryBusiness("Deutschland");
        contact.setTelephoneBusiness1("+49112233445566");
        contact.setCompany("Internal Test AG");
        contact.setEmail1("baab.abba@open-foobar.com");
        this.folderId = this.client.getValues().getPrivateContactFolder();
        contact.setParentFolderID(this.folderId);
        contact.setImage1(Data.image);
        InsertRequest insertContactReq = new InsertRequest(contact);
        InsertResponse insertContactResp = this.client.execute(insertContactReq);
        insertContactResp.fillObject((DataObject)contact);
        this.contactId = contact.getObjectID();
        return contact;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.contact = this.createContactWithImage();
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.contact));
        super.tearDown();
    }

    public void testContactImageWithAllRequest() throws Throwable {
        ListRequest listRequest = new ListRequest(new ListIDs(this.folderId, this.contact.getObjectID()), new int[]{1, 606, 5});
        CommonListResponse response = this.client.execute(listRequest);
        int objectIdPos = response.getColumnPos(1);
        int imageURLPos = response.getColumnPos(606);
        for (Object[] objA : response) {
            if (this.contactId != (Integer)objA[objectIdPos]) continue;
            String imageURL = (String)objA[imageURLPos];
            Bug16618Test.assertNotNull((Object)imageURL);
        }
        AllRequest allRequest = new AllRequest(this.folderId, new int[]{1, 606, 5});
        CommonAllResponse allResponse = this.client.execute(allRequest);
        objectIdPos = allResponse.getColumnPos(1);
        imageURLPos = allResponse.getColumnPos(606);
        int lastModifiedPos = allResponse.getColumnPos(5);
        for (Object[] temp : allResponse) {
            int tempObjectId = (Integer)temp[objectIdPos];
            if (tempObjectId != this.contactId) continue;
            this.contact.setLastModified(new Date((Long)temp[lastModifiedPos]));
            String imageURL = (String)temp[imageURLPos];
            Bug16618Test.assertNotNull((Object)imageURL);
        }
    }
}

