/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.attach;

import com.openexchange.ajax.attach.AbstractAttachmentTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.groupware.tasks.Task;
import java.util.Date;

public class TaskAttachmentTest
extends AbstractAttachmentTest {
    public TaskAttachmentTest(String name) {
        super(name);
    }

    @Override
    public int createExclusiveWritableAttachable(String sessionId, int folderId) throws Exception {
        Task task = new Task();
        task.setTitle("AttachmentTest");
        task.setParentFolderID(folderId);
        int taskId = TaskTools.extractInsertId(TaskTools.insertTask(this.getWebConversation(), this.getHostName(), sessionId, task));
        return taskId;
    }

    @Override
    public int getExclusiveWritableFolder(String sessionId) throws Exception {
        return TaskTools.getPrivateTaskFolder(this.getWebConversation(), this.getHostName(), sessionId);
    }

    @Override
    public int getModule() throws Exception {
        return 4;
    }

    @Override
    public void removeAttachable(int folder, int taskId, String sessionId) throws Exception {
        Response response = TaskTools.getTask(this.getWebConversation(), this.getHostName(), sessionId, this.folderId, taskId);
        Date lastModified = response.getTimestamp();
        TaskTools.deleteTask(this.getWebConversation(), this.getHostName(), sessionId, lastModified, folder, taskId);
    }

    public void testAll() throws Throwable {
        this.doAll();
    }

    public void testMultiple() throws Throwable {
        this.doMultiple();
    }

    public void testDetach() throws Throwable {
        this.doDetach();
    }

    public void testDocument() throws Throwable {
        this.doDocument();
    }

    public void testList() throws Throwable {
        this.doList();
    }

    public void testNotExists() throws Throwable {
        this.doNotExists();
    }

    public void testUpdates() throws Throwable {
        this.doUpdates();
    }

    public void testForbidden() throws Throwable {
        this.doForbidden();
    }

    public void testGet() throws Throwable {
        this.doGet();
    }
}

