/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.helper;

import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.test.CalendarTestManager;
import java.util.List;
import java.util.TimeZone;
import junit.framework.Assert;

public class AbstractAssertion
extends Assert {
    protected String approachUsedForTest;
    protected String methodUsedForTest;
    protected int folder;
    protected CalendarTestManager manager;

    protected String state() {
        return "[" + this.approachUsedForTest + " | " + this.methodUsedForTest + "]";
    }

    protected void fail2(String message) {
        Assert.fail((String)(this.state() + message));
    }

    protected void fail2(String message, Throwable t) {
        t.printStackTrace();
        Assert.fail((String)(this.state() + message));
    }

    protected Appointment find(List<Appointment> appointments, int folderToSearch, int id) {
        for (Appointment app : appointments) {
            if (app.getParentFolderID() != folderToSearch || app.getObjectID() != id) continue;
            return app;
        }
        return null;
    }

    public static Appointment generateDefaultAppointment(int folder) {
        Appointment app = AbstractAssertion.generateDefaultAppointment();
        app.setParentFolderID(folder);
        return app;
    }

    public static Appointment generateDefaultAppointment() {
        Appointment app = new Appointment();
        app.setTitle("Generic recurrence test appointment");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        app.setStartDate(TimeTools.D("1/1/2008 1:00", utc));
        app.setEndDate(TimeTools.D("1/1/2008 2:00", utc));
        app.setIgnoreConflicts(true);
        return app;
    }

    protected Appointment create(Appointment app) {
        return this.manager.insert(app);
    }

    protected void update(Appointment app, Changes changes) {
        Appointment update = new Appointment();
        update.setParentFolderID(app.getParentFolderID());
        update.setObjectID(app.getObjectID());
        update.setLastModified(app.getLastModified());
        changes.update((CommonObject)update);
        this.manager.update(update);
    }
}

