/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import java.util.Calendar;
import java.util.TimeZone;

public class Bug17327Test
extends AbstractAJAXSession {
    AJAXClient client;
    AJAXClient client2;
    FolderObject sharedFolder;
    Appointment appointment;
    TimeZone tz;
    Calendar cal;

    public Bug17327Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.sharedFolder = Create.createPrivateFolder("Bug 17327 shared folder", 2, this.client.getValues().getUserId());
        this.sharedFolder.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        InsertResponse folderInsertResponse = this.client.execute(new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OUTLOOK, this.sharedFolder, true));
        folderInsertResponse.fillObject((DataObject)this.sharedFolder);
        FolderTools.shareFolder(this.client, EnumAPI.OUTLOOK, this.sharedFolder.getObjectID(), this.client2.getValues().getUserId(), 4, 4, 4, 4);
        this.appointment = this.createAppointment();
    }

    public void testAlarmInAllRequest() throws Exception {
        AppointmentInsertResponse insertResponse = this.client.execute(new InsertRequest(this.appointment, this.tz, true));
        insertResponse.fillAppointment(this.appointment);
        CommonAllResponse allResponseBeforeUpdate = this.client2.execute(new AllRequest(this.sharedFolder.getObjectID(), new int[]{204}, this.appointment.getStartDate(), this.appointment.getEndDate(), this.tz));
        GetResponse getResponseBeforeUpdate = this.client2.execute(new GetRequest(this.appointment));
        Object alarmValue = allResponseBeforeUpdate.getValue(0, 204);
        int alarmValueInt = alarmValue == null ? 0 : (Integer)alarmValue;
        Bug17327Test.assertEquals((String)"Alarm is not equal in All- and GetRequest before update.", (int)getResponseBeforeUpdate.getAppointment(this.tz).getAlarm(), (int)alarmValueInt);
        this.appointment.setAlarm(15);
        UpdateResponse updateResponse = this.client.execute(new UpdateRequest(this.appointment, this.tz));
        this.appointment.setLastModified(updateResponse.getTimestamp());
        CommonAllResponse allResponseAfterUpdate = this.client2.execute(new AllRequest(this.sharedFolder.getObjectID(), new int[]{204}, this.appointment.getStartDate(), this.appointment.getEndDate(), this.tz));
        GetResponse getResponseAfterUpdate = this.client2.execute(new GetRequest(this.appointment));
        alarmValue = allResponseAfterUpdate.getValue(0, 204);
        alarmValueInt = alarmValue == null ? 0 : (Integer)alarmValue;
        Bug17327Test.assertEquals((String)"Alarm is not equal in All- and GetRequest after update.", (int)getResponseAfterUpdate.getAppointment(this.tz).getAlarm(), (int)alarmValueInt);
    }

    @Override
    public void tearDown() throws Exception {
        this.client.execute(new com.openexchange.ajax.appointment.action.DeleteRequest(this.appointment));
        this.client.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.sharedFolder));
        this.client2.logout();
        super.tearDown();
    }

    public Appointment createAppointment() throws Exception {
        Appointment appointment = new Appointment();
        appointment.setTitle("Bug 17327 Testappointment");
        appointment.setParentFolderID(this.sharedFolder.getObjectID());
        appointment.setIgnoreConflicts(true);
        this.cal = TimeTools.createCalendar(this.tz);
        appointment.setStartDate(this.cal.getTime());
        this.cal.add(10, 2);
        appointment.setEndDate(this.cal.getTime());
        return appointment;
    }
}

