/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Bug16151Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private AJAXClient client2;
    private Appointment appointment;
    private TimeZone timeZone2;

    public Bug16151Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.timeZone2 = this.client2.getValues().getTimeZone();
        FolderTools.shareFolder(this.client2, EnumAPI.OX_NEW, this.client2.getValues().getPrivateAppointmentFolder(), this.client.getValues().getUserId(), 4, 4, 4, 4);
        this.appointment = new Appointment();
        this.appointment.setTitle("Appointment for bug 16151");
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        Calendar calendar = TimeTools.createCalendar(this.timeZone2);
        this.appointment.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        this.appointment.setEndDate(calendar.getTime());
        InsertRequest request = new InsertRequest(this.appointment, this.timeZone2);
        AppointmentInsertResponse response = this.client.execute(request);
        response.fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        this.appointment.setLastModified(new Date(Long.MAX_VALUE));
        this.client.execute(new DeleteRequest(this.appointment));
        FolderTools.unshareFolder(this.client2, EnumAPI.OX_NEW, this.client2.getValues().getPrivateAppointmentFolder(), this.client.getValues().getUserId());
        super.tearDown();
    }

    public void testMoveFromShared2Private() throws Throwable {
        Appointment moveMe = new Appointment();
        moveMe.setObjectID(this.appointment.getObjectID());
        moveMe.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        moveMe.setLastModified(this.appointment.getLastModified());
        moveMe.setIgnoreConflicts(true);
        TimeZone timeZone = this.client.getValues().getTimeZone();
        UpdateRequest uReq = new UpdateRequest(this.appointment.getParentFolderID(), moveMe, timeZone, true);
        UpdateResponse uResp = this.client.execute(uReq);
        this.appointment.setLastModified(uResp.getTimestamp());
        this.appointment.setParentFolderID(moveMe.getParentFolderID());
        GetRequest gReq = new GetRequest(moveMe.getParentFolderID(), moveMe.getObjectID());
        GetResponse gResp = this.client.execute(gReq);
        Appointment testAppointment = gResp.getAppointment(timeZone);
        ParticipantTools.assertParticipants(testAppointment.getParticipants(), this.client.getValues().getUserId());
    }
}

