/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import java.util.Date;

public class Bug13447Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private int userId;

    public Bug13447Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.userId = this.getClient().getValues().getUserId();
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setTitle("Bug 13447 Test");
        this.appointment.setStartDate(new Date(TimeTools.getHour(0, this.getClient().getValues().getTimeZone())));
        this.appointment.setEndDate(new Date(TimeTools.getHour(1, this.getClient().getValues().getTimeZone())));
        this.appointment.setParticipants(ParticipantTools.createParticipants(this.userId));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(5);
        this.appointment.setIgnoreConflicts(true);
        InsertRequest request = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.getClient().execute(request);
        insertResponse.fillObject((DataObject)this.appointment);
    }

    public void testBug13447() throws Exception {
        Appointment updateAppointment = new Appointment();
        updateAppointment.setObjectID(this.appointment.getObjectID());
        updateAppointment.setLastModified(this.appointment.getLastModified());
        updateAppointment.setParentFolderID(this.appointment.getParentFolderID());
        updateAppointment.setRecurrenceType(0);
        updateAppointment.setIgnoreConflicts(true);
        UpdateRequest update = new UpdateRequest(updateAppointment, this.getClient().getValues().getTimeZone(), true);
        UpdateResponse response = this.getClient().execute(update);
        this.appointment.setLastModified(response.getTimestamp());
        updateAppointment = new Appointment();
        updateAppointment.setObjectID(this.appointment.getObjectID());
        updateAppointment.setLastModified(this.appointment.getLastModified());
        updateAppointment.setParentFolderID(this.appointment.getParentFolderID());
        updateAppointment.setRecurrenceType(1);
        updateAppointment.setInterval(1);
        updateAppointment.setOccurrence(3);
        updateAppointment.setIgnoreConflicts(true);
        update = new UpdateRequest(updateAppointment, this.getClient().getValues().getTimeZone(), true);
        response = this.getClient().execute(update);
        this.appointment.setLastModified(response.getTimestamp());
    }

    @Override
    public void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest(this.appointment.getObjectID(), this.appointment.getParentFolderID(), this.appointment.getLastModified()));
        super.tearDown();
    }
}

