/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.action;

import com.openexchange.ajax.appointment.action.AbstractAppointmentRequest;
import com.openexchange.ajax.appointment.action.SearchParser;
import com.openexchange.ajax.appointment.action.SearchResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.java.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class SearchRequest
extends AbstractAppointmentRequest<SearchResponse> {
    private final JSONObject body = new JSONObject();
    private final SearchParser searchParser;
    private final List<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();

    public SearchRequest(String pattern, int folderId, int[] columns) {
        this(pattern, folderId, columns, true);
    }

    public SearchRequest(String pattern, int inFolder, int[] columns, boolean failOnError) {
        this(pattern, inFolder, null, null, columns, -1, null, false, failOnError);
    }

    public SearchRequest(String pattern, int inFolder, Date startDate, Date endDate, int[] columns, int orderBy, String orderDir, boolean recurrenceMaster, boolean failOnError) {
        this.searchParser = new SearchParser(failOnError, columns);
        this.param("action", "search");
        this.param("columns", Strings.join((int[])columns, (String)", "));
        if (orderBy != -1) {
            this.param("sort", String.valueOf(orderBy));
            this.param("order", orderDir);
        }
        this.param("start", startDate);
        this.param("end", endDate);
        if (recurrenceMaster) {
            this.param("recurrence_master", String.valueOf(recurrenceMaster));
        }
        try {
            if (inFolder != -1) {
                this.body.put("folder", inFolder);
            }
            if (pattern != null) {
                this.body.put("pattern", (Object)pattern);
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    private void param(String key, String value) {
        if (value != null) {
            this.params.add(new AJAXRequest.Parameter(key, value));
        }
    }

    private void param(String key, Date value) {
        if (value != null) {
            this.params.add(new AJAXRequest.Parameter(key, value));
        }
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return this.params.toArray(new AJAXRequest.Parameter[this.params.size()]);
    }

    public SearchParser getParser() {
        return this.searchParser;
    }

    @Override
    public Object getBody() {
        return this.body;
    }
}

