/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.LogPropertyName;
import com.openexchange.log.LogService;
import com.openexchange.log.ReportedThrowableHandler;
import com.openexchange.log.internal.LogServiceImpl;
import com.openexchange.management.ManagementService;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.osgi.NearRegistryServiceTracker;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.session.SessionThreadCounter;
import com.openexchange.sessionCount.SessionThreadCounterImpl;
import com.openexchange.sessiond.SessiondEventConstants;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.internal.ThreadPoolProperties;
import com.openexchange.threadpool.internal.ThreadPoolServiceImpl;
import com.openexchange.threadpool.osgi.ManagementServiceTrackerCustomizer;
import com.openexchange.threadpool.osgi.ManagementServiceTrackerCustomizer2;
import com.openexchange.threadpool.osgi.SessionThreadCountEventHandler;
import com.openexchange.timer.TimerService;
import com.openexchange.timer.internal.CustomThreadPoolExecutorTimerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

public final class ThreadPoolActivator
extends HousekeepingActivator {
    public static final AtomicReference<ThreadPoolService> REF_THREAD_POOL = new AtomicReference();
    public static final AtomicReference<TimerService> REF_TIMER = new AtomicReference();
    private volatile ThreadPoolServiceImpl threadPool;
    private volatile LogServiceImpl logService;

    protected void startBundle() throws Exception {
        Log LOG = com.openexchange.log.Log.loggerFor(ThreadPoolActivator.class);
        try {
            LogServiceImpl logService;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"starting bundle: com.openexchange.threadpool");
            }
            this.configureLogProperties();
            ConfigurationService confService = (ConfigurationService)this.getService(ConfigurationService.class);
            ThreadPoolProperties init = new ThreadPoolProperties().init(confService);
            this.threadPool = ThreadPoolServiceImpl.newInstance(init);
            if (init.isPrestartAllCoreThreads()) {
                this.threadPool.prestartAllCoreThreads();
            }
            NearRegistryServiceTracker reportedThrowableHandlerRegistry = new NearRegistryServiceTracker(this.context, ReportedThrowableHandler.class);
            this.rememberTracker((ServiceTracker)reportedThrowableHandlerRegistry);
            int queueCapacity = confService.getIntProperty("com.openexchange.log.queueCapacity", -1);
            boolean appendTraceToMessage = confService.getBoolProperty("com.openexchange.log.appendTraceToMessage", false);
            com.openexchange.log.Log.setAppendTraceToMessage((boolean)appendTraceToMessage);
            int maxMessageLength = confService.getIntProperty("com.openexchange.log.maxMessageLength", -1);
            boolean reporting = confService.getBoolProperty("com.openexchange.log.reporting", false);
            if (reporting) {
                NearRegistryServiceTracker registry = new NearRegistryServiceTracker(this.context, ReportedThrowableHandler.class);
                this.rememberTracker((ServiceTracker)registry);
                logService = new LogServiceImpl(this.threadPool, queueCapacity, maxMessageLength, (NearRegistryServiceTracker<ReportedThrowableHandler>)registry);
            } else {
                logService = new LogServiceImpl(this.threadPool, queueCapacity, maxMessageLength, null);
            }
            this.logService = logService;
            com.openexchange.log.Log.set((LogService)logService);
            this.track(ManagementService.class, new ManagementServiceTrackerCustomizer(this.context, this.threadPool));
            REF_THREAD_POOL.set(this.threadPool);
            this.registerService(ThreadPoolService.class, this.threadPool);
            CustomThreadPoolExecutorTimerService timerService = new CustomThreadPoolExecutorTimerService(this.threadPool.getThreadPoolExecutor());
            REF_TIMER.set(timerService);
            this.registerService(TimerService.class, timerService);
            this.registerService(LogService.class, logService);
            int notifyThreashold = confService.getIntProperty("com.openexchange.session.maxThreadNotifyThreshold", -1);
            SessionThreadCounterImpl counterImpl = new SessionThreadCounterImpl(notifyThreashold, (ServiceLookup)this);
            this.registerService(SessionThreadCounter.class, counterImpl);
            SessionThreadCounter.REFERENCE.set(counterImpl);
            SessionThreadCountEventHandler handler = new SessionThreadCountEventHandler(this.context, notifyThreashold, counterImpl);
            this.rememberTracker(handler);
            Hashtable<String, Object> dict = new Hashtable<String, Object>(1);
            ((Dictionary)dict).put("event.topics", SessionThreadCounter.EVENT_TOPIC);
            this.registerService(EventHandler.class, (Object)handler, dict);
            this.track(ManagementService.class, new ManagementServiceTrackerCustomizer2(this.context, counterImpl, handler));
            EventHandler sessionEventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    block3: {
                        String topic;
                        block4: {
                            block2: {
                                topic = event.getTopic();
                                if (!"com/openexchange/sessiond/remove/data".equals(topic)) break block2;
                                Map container = (Map)event.getProperty("com.openexchange.sessiond.container");
                                for (Session session : container.values()) {
                                    this.removeFor(session);
                                }
                                break block3;
                            }
                            if (!"com/openexchange/sessiond/remove/session".equals(topic)) break block4;
                            this.removeFor((Session)event.getProperty("com.openexchange.sessiond.session"));
                            break block3;
                        }
                        if (!"com/openexchange/sessiond/remove/container".equals(topic)) break block3;
                        Map container = (Map)event.getProperty("com.openexchange.sessiond.container");
                        for (Session session : container.values()) {
                            this.removeFor(session);
                        }
                    }
                }

                private void removeFor(Session session) {
                    SessionThreadCounter threadCounter = (SessionThreadCounter)SessionThreadCounter.REFERENCE.get();
                    if (null != threadCounter) {
                        threadCounter.remove(session.getSessionID());
                    }
                }
            };
            dict = new Hashtable(1);
            ((Dictionary)dict).put("event.topics", SessiondEventConstants.getAllTopics());
            this.registerService(EventHandler.class, sessionEventHandler, dict);
            this.openTrackers();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed start-up of bundle com.openexchange.threadpool: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private void configureLogProperties() {
        Log log = com.openexchange.log.Log.loggerFor(ThreadPoolActivator.class);
        ConfigurationService service = (ConfigurationService)this.getService(ConfigurationService.class);
        String property = service.getProperty("com.openexchange.log.propertyNames");
        if (null == property) {
            LogProperties.configuredProperties(Collections.emptyList());
        } else {
            List<String> list = Arrays.asList(Strings.splitByComma((String)property));
            ArrayList<LogPropertyName> names = new ArrayList<LogPropertyName>(list.size());
            for (String configuredName : list) {
                if (ThreadPoolActivator.isEmpty(configuredName)) continue;
                int pos = configuredName.indexOf(40);
                if (pos < 0) {
                    LogProperties.Name name = LogProperties.Name.nameFor((String)configuredName);
                    if (null == name) {
                        log.warn((Object)("Unknown log property: " + configuredName));
                        continue;
                    }
                    names.add(new LogPropertyName(name, LogPropertyName.LogLevel.ALL));
                    continue;
                }
                String propertyName = configuredName.substring(0, pos);
                if (ThreadPoolActivator.isEmpty(propertyName)) continue;
                LogProperties.Name name = LogProperties.Name.nameFor((String)propertyName);
                if (null == name) {
                    log.warn((Object)("Unknown log property: " + configuredName));
                    continue;
                }
                int closing = configuredName.indexOf(41, pos + 1);
                if (closing < 0) {
                    names.add(new LogPropertyName(name, LogPropertyName.LogLevel.ALL));
                    continue;
                }
                names.add(new LogPropertyName(name, LogPropertyName.LogLevel.logLevelFor((String)configuredName.substring(pos + 1, closing))));
            }
            LogProperties.configuredProperties(names);
        }
    }

    private static boolean isEmpty(String s) {
        if (s.length() == 0) {
            return true;
        }
        boolean retval = true;
        int length = s.length();
        for (int i = 0; i < length && retval; ++i) {
            retval = Strings.isWhitespace((char)s.charAt(i));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopBundle() throws Exception {
        block9: {
            Log LOG = com.openexchange.log.Log.loggerFor(ThreadPoolActivator.class);
            try {
                ThreadPoolServiceImpl threadPool;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"stopping bundle: com.openexchange.threadpool");
                }
                REF_THREAD_POOL.set(null);
                REF_TIMER.set(null);
                this.cleanUp();
                SessionThreadCounter.REFERENCE.set(null);
                LogServiceImpl logService = this.logService;
                if (null != logService) {
                    logService.stop();
                    this.logService = null;
                    com.openexchange.log.Log.set(null);
                }
                if (null == (threadPool = this.threadPool)) break block9;
                try {
                    threadPool.shutdownNow();
                    threadPool.awaitTermination(10000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.threadPool = null;
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed shut-down of bundle com.openexchange.threadpool: " + e.getMessage()), (Throwable)e);
                throw e;
            }
        }
    }

    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class};
    }

    protected void handleAvailability(Class<?> clazz) {
        Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ThreadPoolActivator.class));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Appeared service: " + clazz.getName()));
        }
    }

    protected void handleUnavailability(Class<?> clazz) {
        Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ThreadPoolActivator.class));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Disappeared service: " + clazz.getName()));
        }
    }
}

