/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.Map;

final class CustomUncaughtExceptionhandler
implements Thread.UncaughtExceptionHandler {
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CustomUncaughtExceptionhandler.class));
        LOG.fatal((Object)("Thread terminated with exception: " + t.getName()), e);
        Map<Thread, StackTraceElement[]> stackMap = Thread.getAllStackTraces();
        StringAllocator sb = new StringAllocator(256);
        String lineSeparator = System.getProperty("line.separator");
        for (Thread thread : stackMap.keySet()) {
            sb.append(thread.getName()).append(" ID:").append(thread.getId());
            sb.append(" State:").append((Object)thread.getState()).append(" Prio:").append(thread.getPriority());
            sb.append(lineSeparator);
            CustomUncaughtExceptionhandler.appendStackTrace(stackMap.get(thread), sb, lineSeparator);
            sb.append(lineSeparator);
        }
        LOG.fatal((Object)sb.toString());
    }

    private static void appendStackTrace(StackTraceElement[] trace, StringAllocator sb, String lineSeparator) {
        if (null == trace) {
            sb.append("<missing stack trace>\n");
            return;
        }
        for (StackTraceElement ste : trace) {
            String className = ste.getClassName();
            if (null == className) continue;
            sb.append("    at ").append(className).append('.').append(ste.getMethodName());
            if (ste.isNativeMethod()) {
                sb.append("(Native Method)");
            } else {
                String fileName = ste.getFileName();
                if (null == fileName) {
                    sb.append("(Unknown Source)");
                } else {
                    int lineNumber = ste.getLineNumber();
                    sb.append('(').append(fileName);
                    if (lineNumber >= 0) {
                        sb.append(':').append(lineNumber);
                    }
                    sb.append(')');
                }
            }
            sb.append(lineSeparator);
        }
    }
}

