/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool;

import com.openexchange.threadpool.RefusedExecutionBehavior;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;

public class BoundedCompletionService<V>
extends ThreadPoolCompletionService<V> {
    private final Semaphore semaphore;

    public BoundedCompletionService(ThreadPoolService threadPoolService, int concurrencyLevel) {
        super(threadPoolService);
        if (concurrencyLevel <= 0) {
            throw new IllegalArgumentException("concurrencyLevel must be greater than zero");
        }
        this.semaphore = new Semaphore(concurrencyLevel);
    }

    public BoundedCompletionService(ThreadPoolService threadPoolService, BlockingQueue<Future<V>> completionQueue, RefusedExecutionBehavior<V> behavior, int concurrencyLevel) {
        super(threadPoolService, completionQueue, behavior);
        if (concurrencyLevel <= 0) {
            throw new IllegalArgumentException("concurrencyLevel must be greater than zero");
        }
        this.semaphore = new Semaphore(concurrencyLevel);
    }

    @Override
    protected void submitFutureTask(FutureTask<V> f) {
        try {
            this.semaphore.acquire();
            super.submitFutureTask(f);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected void taskDone(Future<V> task) {
        this.semaphore.release();
        super.taskDone(task);
    }
}

