/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.helpers;

import com.openexchange.config.ConfigurationService;
import com.openexchange.java.Streams;
import com.openexchange.subscribe.helpers.TrustAllAdapter;
import com.openexchange.subscribe.osgi.SubscriptionServiceRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpContentTooLargeException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class HTTPToolkit {
    private static final String UTF_8 = "UTF-8";

    public static InputStream grabStream(String site) throws IOException {
        return HTTPToolkit.grabStream(site, true);
    }

    public static InputStream grabStream(String site, boolean check) throws IOException {
        HttpClient client = new HttpClient();
        int timeout = 5000;
        client.getParams().setSoTimeout(5000);
        client.getParams().setIntParameter("http.connection.timeout", 5000);
        client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        client.getParams().setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
        client.getParams().setCookiePolicy("compatibility");
        URL javaURL = new URL(site);
        if (check) {
            HTTPToolkit.checkContentAndLength(javaURL, 5000);
        }
        if (javaURL.getProtocol().equalsIgnoreCase("https")) {
            int port = javaURL.getPort();
            if (port == -1) {
                port = 443;
            }
            Protocol https = new Protocol("https", (ProtocolSocketFactory)new TrustAllAdapter(), 443);
            client.getHostConfiguration().setHost(javaURL.getHost(), port, https);
            GetMethod getMethod = new GetMethod(javaURL.getFile());
            getMethod.getParams().setSoTimeout(5000);
            getMethod.setQueryString(javaURL.getQuery());
            client.executeMethod((HttpMethod)getMethod);
            return getMethod.getResponseBodyAsStream();
        }
        GetMethod getMethod = new GetMethod(site);
        client.executeMethod((HttpMethod)getMethod);
        return getMethod.getResponseBodyAsStream();
    }

    public static Reader grab(String site) throws HttpException, IOException {
        return new InputStreamReader(HTTPToolkit.grabStream(site), UTF_8);
    }

    public static Reader post(String site, Map<String, String> values) throws HttpException, IOException {
        HttpClient client = new HttpClient();
        int timeout = 5000;
        client.getParams().setSoTimeout(5000);
        client.getParams().setIntParameter("http.connection.timeout", 5000);
        client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        client.getParams().setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
        client.getParams().setCookiePolicy("compatibility");
        URL javaURL = new URL(site);
        HTTPToolkit.checkContentAndLength(javaURL, 5000);
        if (javaURL.getProtocol().equalsIgnoreCase("https")) {
            int port = javaURL.getPort();
            if (port == -1) {
                port = 443;
            }
            Protocol https = new Protocol("https", (ProtocolSocketFactory)new TrustAllAdapter(), 443);
            client.getHostConfiguration().setHost(javaURL.getHost(), port, https);
            PostMethod postMethod = new PostMethod(javaURL.getFile());
            for (Map.Entry<String, String> entry : values.entrySet()) {
                postMethod.addParameter(new NameValuePair(entry.getKey(), entry.getValue()));
            }
            postMethod.getParams().setSoTimeout(5000);
            postMethod.setQueryString(javaURL.getQuery());
            client.executeMethod((HttpMethod)postMethod);
            return new InputStreamReader(postMethod.getResponseBodyAsStream(), UTF_8);
        }
        PostMethod postMethod = new PostMethod(site);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            postMethod.addParameter(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        client.executeMethod((HttpMethod)postMethod);
        return new InputStreamReader(postMethod.getResponseBodyAsStream(), UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkContentAndLength(URL url, int timeout) throws IOException, HttpException {
        int length;
        String mimeType;
        URLConnection urlCon = url.openConnection();
        try {
            urlCon.setConnectTimeout(timeout);
            urlCon.setReadTimeout(timeout);
            urlCon.connect();
            String ct = urlCon.getContentType();
            mimeType = null == ct ? "application/octet-stream" : ct.toLowerCase(Locale.ENGLISH);
            length = urlCon.getContentLength();
        }
        finally {
            Streams.close((Closeable)urlCon.getInputStream());
        }
        if (!mimeType.startsWith("text/htm")) {
            throw new HttpException("No HTML content. Content-Type is " + mimeType);
        }
        ConfigurationService configurationService = (ConfigurationService)SubscriptionServiceRegistry.getInstance().getService(ConfigurationService.class);
        int maxLen = null == configurationService ? -1 : configurationService.getIntProperty("MAX_UPLOAD_SIZE", -1);
        if (maxLen > 0 && length > maxLen) {
            throw new HttpContentTooLargeException("Content-Length is " + length, maxLen);
        }
    }
}

