/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.folders;

import com.openexchange.ajax.customizer.folder.AdditionalFolderField;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.subscribe.AbstractSubscribeService;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HasSubscriptions
implements AdditionalFolderField {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(HasSubscriptions.class));
    private static final Set<String> ID_BLACKLIST = new HashSet<String>(){
        {
            this.add(String.valueOf(5));
            this.add(String.valueOf(6));
            this.add(String.valueOf(1));
            this.add(String.valueOf(2));
            this.add(String.valueOf(3));
            this.add(String.valueOf(9));
            this.add(String.valueOf(10));
            this.add(String.valueOf(15));
            this.add(String.valueOf(0));
        }
    };

    public int getColumnID() {
        return 3020;
    }

    public String getColumnName() {
        return "com.openexchange.subscribe.subscriptionFlag";
    }

    public Object getValue(FolderObject folder, ServerSession session) {
        return this.getValues(Arrays.asList(folder), session).get(0);
    }

    public List<Object> getValues(List<FolderObject> folder, ServerSession session) {
        if (!session.getUserPermissionBits().isSubscription()) {
            return this.allFalse(folder.size());
        }
        ArrayList<String> folderIdsToQuery = new ArrayList<String>(folder.size());
        ArrayList<String> folderIds = new ArrayList<String>(folder.size());
        HashMap<String, Boolean> hasSubscriptions = new HashMap<String, Boolean>();
        for (FolderObject f : folder) {
            String fn = f.getFullName();
            if (fn == null) {
                fn = String.valueOf(f.getObjectID());
            }
            folderIds.add(fn);
            if (f.getModule() != 7 && !ID_BLACKLIST.contains(fn)) {
                folderIdsToQuery.add(fn);
                continue;
            }
            hasSubscriptions.put(fn, Boolean.FALSE);
        }
        if (folderIdsToQuery.isEmpty()) {
            return this.allFalse(folder.size());
        }
        try {
            hasSubscriptions.putAll(AbstractSubscribeService.STORAGE.get().hasSubscriptions(session.getContext(), folderIdsToQuery));
            ArrayList<Object> retval = new ArrayList<Object>(folder.size());
            for (String fn : folderIds) {
                if (((Boolean)hasSubscriptions.get(fn)).booleanValue()) {
                    retval.add(Boolean.TRUE);
                    continue;
                }
                retval.add(Boolean.FALSE);
            }
            return retval;
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return this.allFalse(folder.size());
        }
    }

    private List<Object> allFalse(int size) {
        ArrayList<Object> retval = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            retval.add(Boolean.FALSE);
        }
        return retval;
    }

    public Object renderJSON(Object value) {
        return value;
    }
}

