/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.log.Log;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;

public final class ManagedServiceTracker
extends ServiceTracker<ManagedService, ManagedService> {
    private final ConfigurationService configService;

    public ManagedServiceTracker(BundleContext context, ConfigurationService configService) {
        super(context, ManagedService.class, null);
        this.configService = configService;
    }

    public ManagedService addingService(ServiceReference<ManagedService> reference) {
        boolean serviceObtained = false;
        try {
            if ("org.apache.felix.webconsole.internal.servlet.OsgiManager".equals(reference.getProperty("service.pid"))) {
                ManagedService service = (ManagedService)super.addingService(reference);
                serviceObtained = true;
                ManagedServiceTracker.configureWebConsole(service, this.configService);
                return service;
            }
        }
        catch (ConfigurationException e) {
            org.apache.commons.logging.Log log = Log.loggerFor(ManagedServiceTracker.class);
            log.warn((Object)"Cannot configure Apache Felix Web Console", (Throwable)e);
        }
        catch (RuntimeException e) {
            org.apache.commons.logging.Log log = Log.loggerFor(ManagedServiceTracker.class);
            log.warn((Object)"Cannot configure Apache Felix Web Console", (Throwable)e);
        }
        if (serviceObtained) {
            this.context.ungetService(reference);
        }
        return null;
    }

    public static void configureWebConsole(ManagedService service, ConfigurationService configService) throws ConfigurationException {
        Hashtable<String, String> properties = new Hashtable<String, String>(6);
        ((Dictionary)properties).put("manager.root", configService.getProperty("com.openexchange.webconsole.servletPath", "/servlet/console"));
        ((Dictionary)properties).put("username", configService.getProperty("com.openexchange.webconsole.username", "open-xchange"));
        ((Dictionary)properties).put("password", configService.getProperty("com.openexchange.webconsole.password", "secret"));
        ((Dictionary)properties).put("realm", configService.getProperty("com.openexchange.webconsole.realm", "Open-Xchange Management Console"));
        service.updated(properties);
    }
}

