/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.FolderTest;
import java.util.Date;
import java.util.Locale;

public class ListTest
extends AppointmentTest {
    public ListTest(String name) {
        super(name);
    }

    public void testPropFindWithModified() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testPropFindWithModified");
        appointmentObj.setIgnoreConflicts(true);
        int objectId1 = ListTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        int objectId2 = ListTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        Appointment loadAppointment = ListTest.loadAppointment(this.getWebConversation(), objectId1, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadAppointment.getCreationDate();
        Appointment[] appointmentArray = ListTest.listAppointment(this.webCon, this.appointmentFolderId, modified, true, false, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.assertTrue((String)"check response", (appointmentArray.length >= 2 ? 1 : 0) != 0);
        int[][] objectIdAndFolderId = new int[][]{{objectId1, this.appointmentFolderId}, {objectId2, this.appointmentFolderId}};
        ListTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testPropFindInPublicFolder() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testPropFindInPublicFolder" + System.currentTimeMillis());
        folderObj.setModule(2);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 128, 128, 128, 128)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testPropFindInPublicFolder");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(parentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment loadAppointment = ListTest.loadAppointment(this.getWebConversation(), objectId, parentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadAppointment.getCreationDate();
        Appointment[] appointmentArray = ListTest.listAppointment(this.webCon, this.appointmentFolderId, modified, true, false, "http://" + this.hostName, this.login, this.password, this.context);
        boolean found = true;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (objectId != appointmentArray[a].getObjectID()) continue;
            found = true;
            break;
        }
        ListTest.assertTrue((String)"object not found in response", (boolean)found);
        ListTest.deleteAppointment(this.getWebConversation(), objectId, parentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testPropFindInPublicFolderWithGroupPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testPropFindInPublicFolderWithGroupPermission" + System.currentTimeMillis());
        folderObj.setModule(2);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        boolean usersGroupId = true;
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 128, 128, 128, 128), FolderTest.createPermission(1, true, 4, 128, 128, 128, false)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testPropFindInPublicFolderWithGroupPermission");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(parentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment loadAppointment = ListTest.loadAppointment(this.getWebConversation(), objectId, parentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadAppointment.getCreationDate();
        Appointment[] appointmentArray = ListTest.listAppointment(this.getSecondWebConversation(), parentFolderId, modified, true, false, "http://" + this.hostName, this.getSecondLogin(), this.getPassword(), this.context);
        boolean found = true;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (objectId != appointmentArray[a].getObjectID()) continue;
            found = true;
            break;
        }
        ListTest.assertTrue((String)"object not found in response", (boolean)found);
        ListTest.deleteAppointment(this.getWebConversation(), objectId, parentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testPropFindWithDelete() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testPropFindWithDelete");
        appointmentObj.setIgnoreConflicts(true);
        int objectId1 = ListTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        int objectId2 = ListTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        Appointment loadAppointment = ListTest.loadAppointment(this.getWebConversation(), objectId1, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadAppointment.getCreationDate();
        int[][] objectIdAndFolderId = new int[][]{{objectId1, this.appointmentFolderId}, {objectId2, this.appointmentFolderId}};
        ListTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        Appointment[] appointmentArray = ListTest.listAppointment(this.webCon, this.appointmentFolderId, modified, false, true, "http://" + this.hostName, this.login, this.password, this.context);
        boolean found = true;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (objectId1 != appointmentArray[a].getObjectID()) continue;
            found = true;
            break;
        }
        ListTest.assertTrue((String)"object not found in response", (boolean)found);
    }

    public void testPropFindWithObjectId() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testPropFindWithObjectId");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ListTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.loadAppointment(this.webCon, objectId, this.appointmentFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        ListTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testObjectNotFound() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testObjectNotFound");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ListTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        try {
            ListTest.loadAppointment(this.webCon, objectId + 1000, this.appointmentFolderId, "http://" + this.hostName, this.login, this.password, this.context);
            ListTest.fail((String)"object not found exception expected!");
        }
        catch (OXException exc) {
            ListTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1001);
        }
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        ListTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testListWithAllFields() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testListWithAllFields");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setLocation("Location");
        appointmentObj.setShownAs(4);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setPrivateFlag(true);
        appointmentObj.setLabel(2);
        appointmentObj.setNote("note");
        appointmentObj.setCategories("testcat1,testcat2,testcat3");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ListTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        Appointment loadAppointment = ListTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadAppointment.getCreationDate();
        Appointment[] appointmentArray = ListTest.listAppointment(this.webCon, this.appointmentFolderId, modified, true, false, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.assertTrue((String)"wrong response array length", (appointmentArray.length >= 1 ? 1 : 0) != 0);
        boolean found = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            Appointment checkAppointment = appointmentArray[a];
            if (checkAppointment.getObjectID() != objectId) continue;
            found = true;
            appointmentObj.setObjectID(objectId);
            ListTest.compareObject(appointmentObj, checkAppointment);
        }
        ListTest.assertTrue((String)"object not found in response", (boolean)found);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        ListTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testList() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testObjectNotFound");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ListTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        int[] idArray = ListTest.listAppointment(this.getWebConversation(), this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        boolean found = false;
        for (int a = 0; a < idArray.length; ++a) {
            if (idArray[a] != objectId) continue;
            found = true;
            break;
        }
        ListTest.assertTrue((String)("id " + objectId + " not found in response"), (boolean)found);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        ListTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }
}

