/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.tools.collections.Collector;
import com.openexchange.tools.collections.Injector;
import com.openexchange.tools.collections.OXCollections;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.ResourceTest;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class CollectionTest
extends ResourceTest {
    public static final String INDEX_HTML = "<html><head /><body>Company Site</body></html>";
    public static final String SITEMAP_HTML = "<html><head /><body>You are here</body></html>";
    public static final String INDEX3_HTML = "<html><head /><body>GUI Site</body></html>";
    public static final String INDEX2_HTML = "<html><head /><body>PM Site</body></html>";
    protected List<WebdavPath> clean = new ArrayList<WebdavPath>();

    @Override
    public void tearDown() throws Exception {
        for (WebdavPath path : this.clean) {
            FACTORY.resolveResource(path).delete();
        }
        super.tearDown();
    }

    @Override
    public void testBody() throws Exception {
        WebdavCollection coll = this.createResource().toCollection();
        String content = "Hallo Welt!";
        byte[] bytes = "Hallo Welt!".getBytes(Charsets.UTF_8);
        try {
            coll.putBody((InputStream)new ByteArrayInputStream(bytes));
            CollectionTest.fail((String)"Collections shouldn't accept bodies");
        }
        catch (WebdavProtocolException x) {
            CollectionTest.assertEquals((int)415, (int)x.getStatus());
        }
    }

    public static void createStructure(WebdavCollection coll, WebdavFactory factory) throws OXException, UnsupportedEncodingException {
        String content = "Hallo Welt!";
        byte[] bytes = "Hallo Welt!".getBytes(Charsets.UTF_8);
        WebdavResource res = coll.resolveResource(new WebdavPath((CharSequence)"index.html"));
        res.putBody((InputStream)new ByteArrayInputStream(INDEX_HTML.getBytes(Charsets.UTF_8)));
        res.setContentType("text/html");
        res.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(bytes));
        res.create();
        res = coll.resolveResource(new WebdavPath((CharSequence)"sitemap.html"));
        res.putBody((InputStream)new ByteArrayInputStream(SITEMAP_HTML.getBytes(Charsets.UTF_8)));
        res.setContentType("text/html");
        res.setLength(Long.valueOf(SITEMAP_HTML.getBytes(Charsets.UTF_8).length));
        res.create();
        res = coll.resolveCollection(new WebdavPath((CharSequence)"development"));
        res.create();
        res = res.toCollection().resolveCollection(new WebdavPath((CharSequence)"gui"));
        res.create();
        res = res.toCollection().resolveResource(new WebdavPath((CharSequence)"index3.html"));
        res.putBody((InputStream)new ByteArrayInputStream(INDEX3_HTML.getBytes(Charsets.UTF_8)));
        res.setContentType("text/html");
        res.setLength(Long.valueOf(INDEX3_HTML.getBytes(Charsets.UTF_8).length));
        res.create();
        res = factory.resolveCollection(coll.getUrl() + "/pm");
        res.create();
        res = coll.resolveCollection(new WebdavPath((CharSequence)"pm")).resolveResource(new WebdavPath((CharSequence)"index2.html"));
        res.putBody((InputStream)new ByteArrayInputStream(INDEX2_HTML.getBytes(Charsets.UTF_8)));
        res.setContentType("text/html");
        res.setLength(Long.valueOf(INDEX2_HTML.getBytes(Charsets.UTF_8).length));
        res.create();
        res = coll.resolveCollection(new WebdavPath((CharSequence)"special characters?"));
        res.create();
    }

    public void testChildren() throws Exception {
        WebdavCollection coll = this.createResource().toCollection();
        CollectionTest.createStructure(coll, this.resourceManager);
        List children = coll.getChildren();
        CollectionTest.assertResources(children, "index.html", "sitemap.html", "development", "pm", "special characters?");
        WebdavCollection dev = coll.resolveCollection(new WebdavPath((CharSequence)"development"));
        children = dev.getChildren();
        CollectionTest.assertResources(children, "gui");
        WebdavCollection gui = dev.resolveCollection(new WebdavPath((CharSequence)"gui"));
        children = gui.getChildren();
        CollectionTest.assertResources(children, "index3.html");
        WebdavCollection pm = coll.resolveCollection(new WebdavPath((CharSequence)"pm"));
        children = pm.getChildren();
        CollectionTest.assertResources(children, "index2.html");
        WebdavResource res = pm.resolveResource(new WebdavPath((CharSequence)"index2.html"));
        res.delete();
        children = pm.getChildren();
        CollectionTest.assertResources(children, new String[0]);
    }

    public void testIterate() throws Exception {
        WebdavCollection coll = this.createResource().toCollection();
        CollectionTest.createStructure(coll, this.resourceManager);
        CollectionTest.assertResources((Iterable<WebdavResource>)coll, "index.html", "sitemap.html", "development", "pm", "gui", "index2.html", "index3.html", "special characters?");
        CollectionTest.assertResources(coll.toIterable(1), "index.html", "sitemap.html", "development", "pm", "special characters?");
        CollectionTest.assertResources(coll.toIterable(0), new String[0]);
        try {
            coll.toIterable(23);
            CollectionTest.fail();
        }
        catch (IllegalArgumentException x) {
            CollectionTest.assertTrue((boolean)true);
        }
    }

    public void testDelete() throws Exception {
        WebdavCollection coll = this.createResource().toCollection();
        CollectionTest.createStructure(coll, this.resourceManager);
        WebdavCollection dev = coll.resolveCollection(new WebdavPath((CharSequence)"development"));
        List subList = new ArrayList<WebdavCollection>();
        subList.add(dev);
        subList = (List)OXCollections.inject(subList, (Iterable)dev, (Injector)new Collector());
        dev.delete();
        CollectionTest.assertResources((Iterable<WebdavResource>)coll, "index.html", "sitemap.html", "pm", "index2.html", "special characters?");
        CollectionTest.assertFalse((boolean)dev.exists());
        for (WebdavResource res : subList) {
            CollectionTest.assertFalse((boolean)res.exists());
        }
    }

    @Override
    public void testMove() throws Exception {
        WebdavCollection coll = this.createResource().toCollection();
        CollectionTest.createStructure(coll, this.resourceManager);
        WebdavCollection dev = coll.resolveCollection(new WebdavPath((CharSequence)"development"));
        Date lastModified = dev.getLastModified();
        Date creationDate = dev.getCreationDate();
        WebdavProperty prop = new WebdavProperty();
        prop.setName("myvalue");
        prop.setNamespace("ox");
        prop.setValue("gnaaa!");
        dev.putProperty(prop);
        List subList = new ArrayList();
        subList = (List)OXCollections.inject(subList, (Iterable)dev, (Injector)new DisplayNameCollector());
        Thread.sleep(1000L);
        WebdavPath url = dev.getUrl();
        dev.move(coll.getUrl().dup().append(new String[]{"dev2"}));
        dev = FACTORY.resolveCollection(url);
        CollectionTest.assertFalse((boolean)dev.exists());
        WebdavCollection dev2 = coll.resolveCollection(new WebdavPath((CharSequence)"dev2"));
        CollectionTest.assertResources((Iterable<WebdavResource>)dev2, subList.toArray(new String[subList.size()]));
        CollectionTest.assertFalse((boolean)lastModified.equals(dev2.getLastModified()));
        CollectionTest.assertEquals((Object)creationDate, (Object)dev2.getCreationDate());
        CollectionTest.assertEquals((String)"gnaaa!", (String)dev2.getProperty("ox", "myvalue").getValue());
        dev.create();
        lastModified = dev.getLastModified();
        Thread.sleep(1000L);
        dev2.move(dev.getUrl(), true, true);
        CollectionTest.assertFalse((boolean)FACTORY.resolveCollection(dev2.getUrl()).exists());
    }

    @Override
    public void testCopy() throws Exception {
        WebdavCollection coll = this.createResource().toCollection();
        CollectionTest.createStructure(coll, this.resourceManager);
        WebdavCollection dev = coll.resolveCollection(new WebdavPath((CharSequence)"development"));
        Date lastModified = dev.getLastModified();
        Date creationDate = dev.getCreationDate();
        WebdavProperty prop = new WebdavProperty();
        prop.setName("myvalue");
        prop.setNamespace("ox");
        prop.setValue("gnaaa!");
        dev.putProperty(prop);
        List subList = new ArrayList();
        subList = (List)OXCollections.inject(subList, (Iterable)dev, (Injector)new DisplayNameCollector());
        Thread.sleep(1000L);
        dev.copy(coll.getUrl().dup().append(new String[]{"dev2"}));
        CollectionTest.assertTrue((boolean)dev.exists());
        WebdavCollection dev2 = coll.resolveCollection(new WebdavPath((CharSequence)"dev2"));
        CollectionTest.assertResources((Iterable<WebdavResource>)dev2, subList.toArray(new String[subList.size()]));
        CollectionTest.assertFalse((boolean)lastModified.equals(dev2.getLastModified()));
        CollectionTest.assertFalse((boolean)creationDate.equals(dev2.getCreationDate()));
        CollectionTest.assertEquals((String)"gnaaa!", (String)dev2.getProperty("ox", "myvalue").getValue());
    }

    @Override
    public void testConflict() throws Exception {
        WebdavResource res = super.createResource();
        try {
            this.resourceManager.resolveCollection(res.getUrl() + "/collection").create();
            CollectionTest.fail();
        }
        catch (WebdavProtocolException x) {
            CollectionTest.assertTrue((String)("" + x.getStatus()), (409 == x.getStatus() || 412 == x.getStatus() ? 1 : 0) != 0);
        }
    }

    public void testMethodNotAllowed() throws Exception {
        WebdavCollection col = this.createResource().toCollection();
        try {
            col.create();
            CollectionTest.fail();
        }
        catch (WebdavProtocolException x) {
            CollectionTest.assertEquals((int)405, (int)x.getStatus());
        }
    }

    @Override
    public void testLock() throws Exception {
        super.testLock();
        WebdavCollection coll = this.createResource().toCollection();
        CollectionTest.createStructure(coll, this.resourceManager);
        WebdavLock lock = new WebdavLock();
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setDepth(-1);
        lock.setOwner("me");
        lock.setTimeout(-1L);
        coll.lock(lock);
        coll.save();
        HashSet<WebdavPath> urls = new HashSet<WebdavPath>();
        for (WebdavResource res : coll) {
            urls.add(res.getUrl());
            CollectionTest.assertNotNull((Object)res.getLock(lock.getToken()));
        }
        coll.unlock(lock.getToken());
        coll.save();
        for (WebdavResource res : coll) {
            CollectionTest.assertNull((Object)res.getLock(lock.getToken()));
        }
        lock.setToken(null);
        lock.setDepth(1);
        coll.lock(lock);
        coll.save();
        for (WebdavResource res : coll.toIterable(1)) {
            urls.remove(res.getUrl());
            CollectionTest.assertNotNull((Object)res.getLock(lock.getToken()));
        }
        for (WebdavPath url : urls) {
            WebdavResource res = this.resourceManager.resolveResource(url);
            CollectionTest.assertEquals((String)(res.getUrl() + " is locked!"), (int)0, (int)res.getLocks().size());
        }
        coll.unlock(lock.getToken());
        coll.save();
    }

    @Override
    public void testOriginalRemainsWhenCopyDisappears() throws Exception {
    }

    @Override
    protected WebdavResource createResource() throws WebdavProtocolException {
        WebdavCollection resource = FACTORY.resolveCollection(this.testCollection + "/testResource" + Math.random());
        CollectionTest.assertFalse((boolean)resource.exists());
        resource.create();
        resource = this.resourceManager.resolveResource(resource.getUrl());
        CollectionTest.assertTrue((boolean)resource.exists());
        return resource;
    }

    @Override
    protected List<Protocol.Property> getPropertiesToTest() {
        return CollectionTest.FACTORY.getProtocol().VALUES;
    }

    @Override
    public Object resourceType() throws WebdavProtocolException {
        WebdavCollection coll = this.createResource().toCollection();
        CollectionTest.assertEquals((String)"<D:collection />", (String)coll.getResourceType());
        CollectionTest.assertEquals((String)coll.getResourceType(), (String)coll.getProperty("DAV:", "resourcetype").getValue());
        return null;
    }

    @Override
    public Object contentLanguage() throws WebdavProtocolException {
        WebdavResource res = this.createResource();
        String defaultLanguage = null;
        CollectionTest.assertEquals((Object)res.getLanguage(), (Object)res.getProperty("DAV:", "getcontentlanguage"));
        CollectionTest.assertEquals(defaultLanguage, (String)res.getLanguage());
        try {
            res.setLanguage("de");
            CollectionTest.fail((String)"Could update language");
        }
        catch (WebdavProtocolException x) {
            CollectionTest.assertTrue((boolean)true);
        }
        WebdavProperty prop = Protocol.GETCONTENTLANGUAGE_LITERAL.getWebdavProperty();
        prop.setValue("de");
        try {
            res.putProperty(prop);
            CollectionTest.fail((String)"Could update language");
        }
        catch (WebdavProtocolException x) {
            CollectionTest.assertTrue((boolean)true);
        }
        return null;
    }

    @Override
    public Object contentLength() throws WebdavProtocolException {
        WebdavResource res = this.createResource();
        CollectionTest.assertEquals((Object)res.getLength(), (Object)res.getProperty("DAV:", "getcontentlength"));
        CollectionTest.assertEquals(null, (Object)res.getLength());
        try {
            res.setLength(Long.valueOf(23L));
            CollectionTest.fail((String)"Could update length");
        }
        catch (WebdavProtocolException x) {
            CollectionTest.assertTrue((boolean)true);
        }
        WebdavProperty prop = Protocol.GETCONTENTLENGTH_LITERAL.getWebdavProperty();
        prop.setValue("2");
        try {
            res.putProperty(prop);
            CollectionTest.fail((String)"Could update length");
        }
        catch (WebdavProtocolException x) {
            CollectionTest.assertTrue((boolean)true);
        }
        return null;
    }

    @Override
    public Object etag() throws WebdavProtocolException {
        WebdavResource res = this.createResource();
        CollectionTest.assertEquals((Object)res.getETag(), (Object)res.getProperty("DAV:", "getetag"));
        CollectionTest.assertEquals(null, (String)res.getETag());
        return null;
    }

    @Override
    public Object contentType() throws WebdavProtocolException {
        WebdavResource res = this.createResource();
        try {
            res.setContentType("text/plain");
            CollectionTest.fail((String)"Could update content type");
        }
        catch (WebdavProtocolException x) {
            CollectionTest.assertTrue((boolean)true);
        }
        WebdavProperty prop = Protocol.GETCONTENTTYPE_LITERAL.getWebdavProperty();
        prop.setValue("text/plain");
        try {
            res.putProperty(prop);
            CollectionTest.fail((String)"Could update content type");
        }
        catch (WebdavProtocolException x) {
            CollectionTest.assertTrue((boolean)true);
        }
        return null;
    }

    protected static final class DisplayNameCollector
    implements Injector<List<String>, WebdavResource> {
        protected DisplayNameCollector() {
        }

        public List<String> inject(List<String> list, WebdavResource element) {
            try {
                list.add(element.getDisplayName());
            }
            catch (OXException e) {
                list.add(e.toString());
            }
            return list;
        }
    }
}

