/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.infostore.integration;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.AbstractInfostoreTest;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.webdav.DocumentMetadataResource;
import com.openexchange.groupware.infostore.webdav.FolderCollection;
import com.openexchange.groupware.infostore.webdav.InfostoreWebdavFactory;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Charsets;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.webdav.protocol.TestWebdavFactoryBuilder;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class LockExpiryTest
extends AbstractInfostoreTest {
    protected WebdavPath testCollection = new WebdavPath(new String[]{"public_infostore", "testCollection" + Math.random()});
    private InfostoreWebdavFactory factory = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.factory = (InfostoreWebdavFactory)TestWebdavFactoryBuilder.buildFactory();
        this.factory.beginRequest();
    }

    @Override
    public void tearDown() throws OXException {
        this.resolveFolder(this.testCollection).delete();
        this.factory.endRequest(200);
    }

    public void testExpiredLocksOnInfoitemsHaveThemShowUpInUpdatesResponse() throws OXException, UnsupportedEncodingException, InterruptedException, OXException {
        FolderCollection folderCollection = this.resolveFolder(this.testCollection);
        folderCollection.create();
        InfostoreFacade infostoreFacade = this.factory.getDatabase();
        Context ctx = this.factory.getSession().getContext();
        User user = this.factory.getSession().getUser();
        UserPermissionBits userConfig = this.factory.getSession().getUserPermissionBits();
        DocumentMetadataResource resource = this.createResource();
        WebdavLock lock = new WebdavLock();
        lock.setDepth(0);
        lock.setOwner("me");
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        lock.setTimeout(2000L);
        resource.lock(lock);
        this.newRequest();
        Date lastModified = infostoreFacade.getDocumentMetadata(resource.getId(), -1, ctx, user, userConfig).getLastModified();
        Thread.sleep(2001L);
        this.newRequest();
        Delta delta = infostoreFacade.getDelta((long)folderCollection.getId(), lastModified.getTime() + 10L, new Metadata[]{Metadata.ID_LITERAL}, true, ctx, user, userConfig);
        boolean found = false;
        SearchIterator modified = delta.getModified();
        while (modified.hasNext()) {
            DocumentMetadata document = (DocumentMetadata)modified.next();
            if (document.getId() != resource.getId()) continue;
            found = true;
        }
        LockExpiryTest.assertTrue((String)"Did not find document with autoexpired lock in delta", (boolean)found);
    }

    private FolderCollection resolveFolder(WebdavPath url) throws OXException {
        return (FolderCollection)this.factory.resolveCollection(url);
    }

    protected DocumentMetadataResource createResource() throws OXException, UnsupportedEncodingException {
        String name = "/testResource" + Math.random();
        WebdavResource resource = this.factory.resolveResource(this.testCollection + name);
        LockExpiryTest.assertFalse((boolean)resource.exists());
        resource.create();
        resource.putBodyAndGuessLength((InputStream)new ByteArrayInputStream("Hallo Welt".getBytes(Charsets.UTF_8)));
        this.newRequest();
        resource = this.factory.resolveResource(this.testCollection + name);
        LockExpiryTest.assertTrue((boolean)resource.exists());
        return (DocumentMetadataResource)resource;
    }

    private void newRequest() {
        this.factory.endRequest(200);
        this.factory.beginRequest();
    }
}

