/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.osgi;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.cookies.CookieJar;
import com.openexchange.ajax.Login;
import com.openexchange.ajax.LoginTest;
import com.openexchange.test.osgi.AbstractBundleTest;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public final class BundleTestIMAP
extends AbstractBundleTest {
    private static final String BUNDLE_ID = "com.openexchange.imap";
    private static final String MAIL_URL = "/ajax/mail";

    public BundleTestIMAP(String name) {
        super(name);
    }

    public void testIMAPAbsence() {
        try {
            LoginTest loginTest = new LoginTest("LoginTest");
            JSONObject jsonObject = BundleTestIMAP.login(this.getWebConversation(), loginTest.getHostName(), loginTest.getLogin(), loginTest.getPassword());
            BundleTestIMAP.assertTrue((String)"Error contained in returned JSON object", (!jsonObject.has("error") || jsonObject.isNull("error") ? 1 : 0) != 0);
            BundleTestIMAP.assertTrue((String)"Missing session ID", (jsonObject.has("session") && !jsonObject.isNull("session") ? 1 : 0) != 0);
            String sessionId = jsonObject.getString("session");
            JSONObject mailObject = BundleTestIMAP.getAllMails(this.getWebConversation(), loginTest.getHostName(), sessionId, "INBOX", null, true);
            BundleTestIMAP.assertTrue((String)"No error contained in returned JSON object", (mailObject.has("error") && !mailObject.isNull("error") ? 1 : 0) != 0);
            BundleTestIMAP.assertTrue((String)"Missing error code", (mailObject.has("code") && !mailObject.isNull("code") ? 1 : 0) != 0);
            BundleTestIMAP.assertTrue((String)("Unexpected error code: " + mailObject.getString("code")), (boolean)"MSG-0044".equals(mailObject.get("code")));
        }
        catch (Exception e) {
            e.printStackTrace();
            BundleTestIMAP.fail((String)e.getMessage());
        }
    }

    private static JSONObject getAllMails(WebConversation conversation, String hostname, String sessionId, String folder, int[] cols, boolean setCookie) throws IOException, SAXException, JSONException {
        String colsStr;
        GetMethodWebRequest getReq = new GetMethodWebRequest("http://" + hostname + MAIL_URL);
        if (setCookie) {
            CookieJar cookieJar = new CookieJar();
            cookieJar.putCookie(Login.SESSION_PREFIX + sessionId, sessionId);
        }
        getReq.setParameter("session", sessionId);
        getReq.setParameter("action", "all");
        getReq.setParameter("folder", folder);
        if (cols != null && cols.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(cols[0]);
            for (int i = 1; i < cols.length; ++i) {
                sb.append(',').append(cols[i]);
            }
            colsStr = sb.toString();
        } else {
            colsStr = "600,601,602,612,603,607,610,608,611,614,102";
        }
        getReq.setParameter("columns", colsStr);
        getReq.setParameter("sort", "610");
        getReq.setParameter("order", "asc");
        WebResponse resp = conversation.getResponse((WebRequest)getReq);
        JSONObject jResponse = new JSONObject(resp.getText());
        return jResponse;
    }

    @Override
    protected String getBundleName() {
        return BUNDLE_ID;
    }
}

