/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.MailField;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import junit.framework.Assert;

public final class MailAccessTest
extends AbstractMailTest {
    public MailAccessTest() {
    }

    public MailAccessTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailAccess() throws OXException, InterruptedException {
        SessionObject session = this.getSession();
        MailAccess mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        mailAccess.close(true);
        try {
            mailAccess = MailAccess.getInstance((Session)session);
            MailConfig mailConfig = mailAccess.getMailConfig();
            mailConfig.setLogin(this.getLogin());
            mailConfig.setPassword(this.getPassword());
            mailConfig.setServer(this.getServer());
            mailConfig.setPort(this.getPort());
            mailAccess.connect();
        }
        catch (Exception e) {
        }
        finally {
            try {
                mailAccess.close(false);
            }
            catch (Exception e2) {}
        }
        mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        mailAccess.close(false);
        session.setPassword(null);
        mailAccess = MailAccess.getInstance((Session)session);
        try {
            mailAccess.connect();
            MailAccessTest.assertTrue((String)"Connect invocation should fail", (boolean)false);
        }
        catch (Exception e) {
            MailAccessTest.assertTrue((boolean)true);
        }
        session.setPassword(this.getPassword());
        mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        mailAccess.getMessageStorage().getAllMessages("INBOX", null, null, null, new MailField[]{MailField.ID});
        mailAccess.close(true);
        Thread.sleep(10000L);
    }

    public void testSimultaneousConnections() throws InterruptedException {
        MyRunnable runnable = new MyRunnable(this);
        Thread[] threads = new Thread[50];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(runnable);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        boolean wait = true;
        while (wait) {
            wait = false;
            for (int i = 0; i < threads.length && !wait; ++i) {
                wait = threads[i].isAlive();
            }
            if (!wait) continue;
            Thread.sleep(1000L);
        }
        Thread.sleep(10000L);
        MailAccessTest.assertTrue((String)"Zero connections should be open", (0 == MailAccess.getCounter() ? 1 : 0) != 0);
    }

    private static final class MyRunnable
    implements Runnable {
        private final AbstractMailTest testRef;

        public MyRunnable(AbstractMailTest testRef) {
            this.testRef = testRef;
        }

        @Override
        public void run() {
            try {
                SessionObject session = SessionObjectWrapper.createSessionObject((int)this.testRef.getUser(), (Context)new ContextImpl(this.testRef.getCid()), (String)"mail-test-session");
                session.setPassword(this.testRef.getPassword());
                MailAccess mailAccess = MailAccess.getInstance((Session)session);
                mailAccess.connect();
                mailAccess.close(false);
                mailAccess = MailAccess.getInstance((Session)session);
                mailAccess.connect();
                mailAccess.close(false);
                session.setPassword(null);
                mailAccess = MailAccess.getInstance((Session)session);
                try {
                    mailAccess.connect();
                    Assert.assertTrue((String)"Connect invocation should fail", (boolean)false);
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)true);
                }
                session.setPassword(this.testRef.getPassword());
                mailAccess = MailAccess.getInstance((Session)session);
                mailAccess.connect();
                mailAccess.getMessageStorage().getAllMessages("INBOX", null, null, null, new MailField[]{MailField.ID});
                mailAccess.close(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

