/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.links;

import com.openexchange.api2.LinkSQLInterface;
import com.openexchange.api2.RdbLinkSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.CalendarListener;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.LinkObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.links.CopyLinksForChangeExceptions;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.session.Session;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class CopyLinksForChangeExceptionsTest
extends TestCase {
    private CalendarListener listener;
    private String user;
    private Context ctx;
    private CommonAppointments appointments;
    private int userId;
    private Session session;
    private final List<CalendarDataObject> clean = new ArrayList<CalendarDataObject>();
    private User userObject;
    private UserConfiguration userConfig;
    private LinkSQLInterface links;

    public void setUp() throws Exception {
        Init.startServer();
        this.links = new RdbLinkSQLInterface();
        this.listener = new CopyLinksForChangeExceptions(this.links);
        TestConfig config = new TestConfig();
        this.user = config.getUser();
        TestContextToolkit tools = new TestContextToolkit();
        this.ctx = tools.getDefaultContext();
        this.appointments = new CommonAppointments(this.ctx, this.user);
        this.userId = tools.resolveUser(this.user, this.ctx);
        this.userObject = UserStorage.getInstance().getUser(this.userId, this.ctx);
        this.userConfig = UserConfigurationStorage.getInstance().getUserConfiguration(this.userId, this.ctx);
        this.session = tools.getSessionForUser(this.user, this.ctx);
    }

    public void tearDown() throws Exception {
        this.appointments.removeAll(this.user, this.clean);
        Init.stopServer();
    }

    public void testShouldCopyLinks() throws OXException, IOException {
        CalendarDataObject master = this.appointments.buildBasicAppointment(CommonAppointments.D("10/02/2008 10:00"), CommonAppointments.D("10/02/2008 12:00"));
        master.setRecurrenceType(1);
        master.setInterval(1);
        master.setOccurrence(10);
        this.appointments.save(master);
        this.clean.add(master);
        CalendarDataObject exception = this.appointments.createIdentifyingCopy(master);
        exception.setRecurrencePosition(3);
        exception.setStartDate(CommonAppointments.D("13/02/2008 13:00"));
        exception.setEndDate(CommonAppointments.D("13/02/2008 15:00"));
        this.appointments.save(exception);
        CalendarDataObject appointmentToLinkTo = this.appointments.buildBasicAppointment(CommonAppointments.D("10/02/2008 17:00"), CommonAppointments.D("10/02/2008 19:00"));
        this.appointments.save(appointmentToLinkTo);
        this.clean.add(appointmentToLinkTo);
        LinkObject link = new LinkObject();
        link.setFirstFolder(master.getParentFolderID());
        link.setFirstId(master.getObjectID());
        link.setFirstType(1);
        link.setSecondFolder(appointmentToLinkTo.getParentFolderID());
        link.setSecondId(appointmentToLinkTo.getObjectID());
        link.setSecondType(1);
        link.setContext(this.ctx.getContextId());
        this.links.saveLink(link, this.userId, this.userConfig.getGroups(), this.session);
        this.listener.createdChangeExceptionInRecurringAppointment((Appointment)master, (Appointment)exception, 0, ServerSessionAdapter.valueOf((Session)this.session));
        LinkObject[] loadedLinks = this.links.getLinksOfObject(exception.getObjectID(), 1, exception.getParentFolderID(), this.userId, this.userConfig.getGroups(), this.session);
        CopyLinksForChangeExceptionsTest.assertNotNull((Object)loadedLinks);
        CopyLinksForChangeExceptionsTest.assertEquals((int)1, (int)loadedLinks.length);
        LinkObject loadedLink = loadedLinks[0];
        CopyLinksForChangeExceptionsTest.assertEquals((int)exception.getObjectID(), (int)loadedLink.getFirstId());
        CopyLinksForChangeExceptionsTest.assertEquals((int)1, (int)loadedLink.getFirstType());
        CopyLinksForChangeExceptionsTest.assertEquals((int)exception.getParentFolderID(), (int)loadedLink.getFirstFolder());
        CopyLinksForChangeExceptionsTest.assertEquals((int)appointmentToLinkTo.getObjectID(), (int)loadedLink.getSecondId());
        CopyLinksForChangeExceptionsTest.assertEquals((int)1, (int)loadedLink.getSecondType());
        CopyLinksForChangeExceptionsTest.assertEquals((int)appointmentToLinkTo.getParentFolderID(), (int)loadedLink.getSecondFolder());
    }
}

