/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.Resolved;
import com.openexchange.groupware.infostore.WebdavFolderAliases;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.infostore.paths.impl.PathResolverImpl;
import com.openexchange.groupware.infostore.webdav.InMemoryAliases;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavPathTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.TestCase;

public class PathResolverTest
extends TestCase {
    private final DBProvider provider = new DBPoolProvider();
    private final InfostoreFacade database = new InfostoreFacadeImpl(this.provider);
    private final PathResolverImpl pathResolver = new PathResolverImpl(this.provider, this.database);
    private int root;
    private int id9;
    private int id8;
    private int id7;
    private int id6;
    private int id5;
    private int id4;
    private int id3;
    private int id2;
    private int id;
    private final int type = 2;
    ServerSession session;
    private Context ctx = null;
    private User user;
    private UserPermissionBits userPerm;

    public void setUp() throws Exception {
        Init.startServer();
        this.database.setTransactional(true);
        this.ctx = this.getContext();
        UserStorage userStorage = UserStorage.getInstance();
        UserPermissionBitsStorage userConfigStorage = UserPermissionBitsStorage.getInstance();
        this.session = ServerSessionFactory.createServerSession(userStorage.getUserId(this.getUsername(), this.ctx), this.ctx, "gnitzelgnatzel");
        this.user = userStorage.getUser(this.session.getUserId(), this.ctx);
        this.userPerm = userConfigStorage.getUserPermissionBits(this.session.getUserId(), this.ctx);
        this.findRoot();
        this.pathResolver.startTransaction();
        this.root = this.mkdir(this.root, "folder-" + System.currentTimeMillis());
        this.id = this.mkdir(this.root, "this");
        this.id2 = this.mkdir(this.id, "is");
        this.id3 = this.mkdir(this.id2, "a");
        this.id4 = this.mkdir(this.id3, "nice");
        this.id5 = this.mkdir(this.id4, "path");
        this.id6 = this.touch(this.id5, "document.txt");
        this.id7 = this.mkdir(this.id5, "path");
        this.id8 = this.mkdir(this.id7, "path");
        this.id9 = this.mkdir(this.id8, "path");
    }

    private Context getContext() throws OXException {
        try {
            TestConfig config = new TestConfig();
            TestContextToolkit tools = new TestContextToolkit();
            String ctxName = config.getContextName();
            return null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        }
        catch (OXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void tearDown() throws Exception {
        this.pathResolver.finish();
        this.rmdir(this.id9);
        this.rmdir(this.id8);
        this.rmdir(this.id7);
        this.rmdir(this.id5);
        this.rmdir(this.id4);
        this.rmdir(this.id3);
        this.rmdir(this.id2);
        this.rmdir(this.id);
        this.rmdir(this.root);
        Init.stopServer();
    }

    private void findRoot() throws Exception {
        OXFolderAccess oxfa = new OXFolderAccess(this.ctx);
        this.root = oxfa.getDefaultFolder(this.user.getId(), 8).getObjectID();
    }

    private String getUsername() {
        try {
            TestConfig config = new TestConfig();
            String userName = config.getUser();
            int pos = userName.indexOf(64);
            return pos == -1 ? userName : userName.substring(0, pos);
        }
        catch (OXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void testResolvePathDocument() throws Exception {
        Resolved resolved = this.pathResolver.resolve(this.root, new WebdavPath((CharSequence)"/this/is/a/nice/path/document.txt"), this.ctx, this.user, this.userPerm);
        PathResolverTest.assertTrue((boolean)resolved.isDocument());
        PathResolverTest.assertFalse((boolean)resolved.isFolder());
        PathResolverTest.assertEquals((int)this.id6, (int)resolved.getId());
        resolved = this.pathResolver.resolve(this.id2, new WebdavPath((CharSequence)"a/nice/path/document.txt"), this.ctx, this.user, this.userPerm);
        PathResolverTest.assertTrue((boolean)resolved.isDocument());
        PathResolverTest.assertFalse((boolean)resolved.isFolder());
        PathResolverTest.assertEquals((int)this.id6, (int)resolved.getId());
    }

    public void testResolvePathFolder() throws Exception {
        Resolved resolved = this.pathResolver.resolve(this.root, new WebdavPath((CharSequence)"/this/is/a/nice/path"), this.ctx, this.user, this.userPerm);
        PathResolverTest.assertFalse((boolean)resolved.isDocument());
        PathResolverTest.assertTrue((boolean)resolved.isFolder());
        PathResolverTest.assertEquals((int)this.id5, (int)resolved.getId());
        resolved = this.pathResolver.resolve(this.id2, new WebdavPath((CharSequence)"a/nice/path"), this.ctx, this.user, this.userPerm);
        PathResolverTest.assertFalse((boolean)resolved.isDocument());
        PathResolverTest.assertTrue((boolean)resolved.isFolder());
        PathResolverTest.assertEquals((int)this.id5, (int)resolved.getId());
    }

    public void testGetPathDocument() throws Exception {
        WebdavPath path = this.pathResolver.getPathForDocument(this.root, this.id6, this.ctx, this.user, this.userPerm);
        WebdavPathTest.assertComponents(path, "this", "is", "a", "nice", "path", "document.txt");
    }

    public void testGetPathFolder() throws Exception {
        WebdavPath path = this.pathResolver.getPathForFolder(this.root, this.id5, this.ctx, this.user, this.userPerm);
        WebdavPathTest.assertComponents(path, "this", "is", "a", "nice", "path");
    }

    public void testNotExists() throws Exception {
        try {
            this.pathResolver.resolve(this.root, new WebdavPath((CharSequence)"/i/dont/exist"), this.ctx, this.user, this.userPerm);
            PathResolverTest.fail((String)"Expected OXObjectNotFoundException");
        }
        catch (OXException x) {
            PathResolverTest.assertTrue((boolean)true);
        }
    }

    public void testCaseSensitive() throws Exception {
        try {
            this.pathResolver.resolve(this.root, new WebdavPath((CharSequence)"/this/is/a/nice/path/DoCuMeNt.txt"), this.ctx, this.user, this.userPerm);
            PathResolverTest.fail((String)"Expected OXObjectNotFoundException");
        }
        catch (OXException x) {
            PathResolverTest.assertTrue((boolean)true);
        }
        try {
            this.pathResolver.resolve(this.root, new WebdavPath((CharSequence)"/this/is/a/nice/PaTh"), this.ctx, this.user, this.userPerm);
            PathResolverTest.fail((String)"Expected OXObjectNotFoundException");
        }
        catch (OXException x) {
            PathResolverTest.assertTrue((boolean)true);
        }
    }

    public void testRespectsAliases() throws OXException {
        InMemoryAliases aliases = new InMemoryAliases();
        aliases.registerNameWithIDAndParent("ALIAS!", this.id5, this.id4);
        this.pathResolver.setAliases((WebdavFolderAliases)aliases);
        Resolved resolved = this.pathResolver.resolve(this.root, new WebdavPath((CharSequence)"/this/is/a/nice/ALIAS!"), this.ctx, this.user, this.userPerm);
        PathResolverTest.assertFalse((boolean)resolved.isDocument());
        PathResolverTest.assertTrue((boolean)resolved.isFolder());
        PathResolverTest.assertEquals((int)this.id5, (int)resolved.getId());
        this.pathResolver.clearCache();
        WebdavPath path = this.pathResolver.getPathForFolder(this.root, this.id5, this.ctx, this.user, this.userPerm);
        WebdavPathTest.assertComponents(path, "this", "is", "a", "nice", "ALIAS!");
        this.pathResolver.clearCache();
        try {
            this.pathResolver.resolve(this.root, new WebdavPath((CharSequence)"this/ALIAS!/a/nice"), this.ctx, this.user, this.userPerm);
            PathResolverTest.fail((String)"Expected OXObjectNotFoundException");
        }
        catch (OXException x) {
            PathResolverTest.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int mkdir(int parent, String name) throws SQLException, OXException, Exception {
        FolderObject folder = new FolderObject();
        folder.setFolderName(name);
        folder.setParentFolderID(parent);
        folder.setType(2);
        folder.setModule(8);
        OCLPermission perm = new OCLPermission();
        perm.setEntity(this.user.getId());
        perm.setFolderAdmin(true);
        perm.setFolderPermission(128);
        perm.setReadObjectPermission(128);
        perm.setWriteObjectPermission(128);
        perm.setDeleteObjectPermission(128);
        perm.setGroupPermission(false);
        OCLPermission perm2 = new OCLPermission();
        perm2.setEntity(0);
        perm2.setGroupPermission(true);
        perm2.setFolderPermission(4);
        perm2.setReadObjectPermission(4);
        perm2.setWriteObjectPermission(4);
        perm2.setDeleteObjectPermission(4);
        folder.setPermissionsAsArray(new OCLPermission[]{perm, perm2});
        Connection writeCon = null;
        try {
            writeCon = this.provider.getWriteConnection(this.ctx);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session, (Connection)writeCon, (Connection)writeCon);
            oxma.createFolder(folder, true, System.currentTimeMillis());
        }
        finally {
            if (writeCon != null) {
                this.provider.releaseWriteConnection(this.ctx, writeCon);
            }
        }
        return folder.getObjectID();
    }

    private int touch(int parent, String filename) throws Exception {
        DocumentMetadataImpl m = new DocumentMetadataImpl();
        m.setFolderId((long)parent);
        m.setFileName(filename);
        m.setId(-1);
        this.database.startTransaction();
        try {
            this.database.saveDocument((DocumentMetadata)m, (InputStream)new ByteArrayInputStream(new byte[10]), Long.MAX_VALUE, this.session);
            this.database.commit();
        }
        catch (Exception x) {
            this.database.rollback();
            throw x;
        }
        finally {
            this.database.finish();
        }
        return m.getId();
    }

    private void rmdir(int id) throws SQLException, OXException, OXException, Exception {
        OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
        oxma.deleteFolder(new FolderObject(id), true, System.currentTimeMillis());
    }
}

