/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.importexport.AbstractContactTest;
import com.openexchange.groupware.userconfiguration.MutableUserConfiguration;
import com.openexchange.groupware.userconfiguration.OverridingUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.importexport.exceptions.ImportExportExceptionCodes;
import com.openexchange.importexport.formats.Format;
import com.openexchange.importexport.importers.TestCSVContactImporter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.BeforeClass;

public class Bug8681forCSV
extends AbstractContactTest {
    private static Context ctx;

    public static Test suite() {
        return new JUnit4TestAdapter(Bug8681forCSV.class);
    }

    @BeforeClass
    public static void initialize() throws Exception {
        AbstractContactTest.initialize();
        ctx = ContextStorage.getInstance().getContext(ContextStorage.getInstance().getContextId("defaultcontext"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void testOurCSV() throws Exception {
        imp = new TestCSVContactImporter();
        folderId = Bug8681forCSV.createTestFolder(3, sessObj, ctx, "bug8681 for csv");
        UserConfigurationStorage original = UserConfigurationStorage.getInstance();
        OverridingUserConfigurationStorage override = new OverridingUserConfigurationStorage(original){

            @Override
            public UserConfiguration getOverride(int userId, int[] groups, Context ctx) throws OXException {
                UserConfiguration orig = this.delegate.getUserConfiguration(userId, ctx);
                MutableUserConfiguration copy = orig.getMutable();
                copy.setContact(false);
                return copy;
            }
        };
        override.override();
        try {
            String csv = "Given name,Email 1\nPrinz, tobias.prinz@open-xchange.com\nLaguna, francisco.laguna@open-xchange.com";
            imp.canImport(sessObj, Format.CSV, this._folders(), null);
            imp.importData(sessObj, Format.CSV, (InputStream)new ByteArrayInputStream("Given name,Email 1\nPrinz, tobias.prinz@open-xchange.com\nLaguna, francisco.laguna@open-xchange.com".getBytes()), this._folders(), null);
            Assert.fail((String)"Could write contact without rights to use Contact module");
        }
        catch (OXException e) {
            Assert.assertTrue((boolean)e.similarTo(ImportExportExceptionCodes.CONTACTS_DISABLED.create()));
        }
        finally {
            override.takeBack();
            Bug8681forCSV.deleteTestFolder(folderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void testOutlookCSV() throws Exception {
        imp = new TestCSVContactImporter();
        folderId = Bug8681forCSV.createTestFolder(3, sessObj, ctx, "bug8681 for Outlook CSV");
        UserConfigurationStorage original = UserConfigurationStorage.getInstance();
        OverridingUserConfigurationStorage override = new OverridingUserConfigurationStorage(original){

            @Override
            public UserConfiguration getOverride(int userId, int[] groups, Context ctx) throws OXException {
                UserConfiguration orig = this.delegate.getUserConfiguration(userId, ctx);
                MutableUserConfiguration copy = orig.getMutable();
                copy.setContact(false);
                return copy;
            }
        };
        override.override();
        try {
            String csv = "Given name,Email 1\nPrinz, tobias.prinz@open-xchange.com\nLaguna, francisco.laguna@open-xchange.com";
            imp.canImport(sessObj, Format.OUTLOOK_CSV, this._folders(), null);
            imp.importData(sessObj, Format.OUTLOOK_CSV, (InputStream)new ByteArrayInputStream("Given name,Email 1\nPrinz, tobias.prinz@open-xchange.com\nLaguna, francisco.laguna@open-xchange.com".getBytes()), this._folders(), null);
            Assert.fail((String)"Could write contact without rights to use Contact module");
        }
        catch (OXException e) {
            Assert.assertTrue((boolean)e.similarTo((OXExceptionCode)ImportExportExceptionCodes.CONTACTS_DISABLED));
        }
        finally {
            override.takeBack();
            Bug8681forCSV.deleteTestFolder(folderId);
        }
    }
}

