/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AbstractCalendarTest;
import com.openexchange.groupware.calendar.CalendarCallbacks;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.CalendarListener;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import junit.framework.Assert;

public class Bug12377Test
extends CalendarSqlTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShouldDoCallbackWhenHavingCreatedAnException() throws OXException {
        AbstractCalendarTest.TestCalendarListener calendarListener = new AbstractCalendarTest.TestCalendarListener();
        CalendarCallbacks.getInstance().addListener((CalendarListener)calendarListener);
        try {
            final CalendarDataObject master = this.appointments.buildBasicAppointment(CommonAppointments.D("10/02/2008 10:00"), CommonAppointments.D("10/02/2008 12:00"));
            master.setRecurrenceType(1);
            master.setInterval(1);
            master.setOccurrence(10);
            this.appointments.save(master);
            this.clean.add(master);
            CalendarDataObject exception = this.appointments.createIdentifyingCopy(master);
            exception.setRecurrencePosition(3);
            exception.setStartDate(CommonAppointments.D("13/02/2008 13:00"));
            exception.setEndDate(CommonAppointments.D("13/02/2008 15:00"));
            calendarListener.clear();
            final int[] changeExceptionId = new int[1];
            calendarListener.setVerifyer(new AbstractCalendarTest.Verifyer(){

                @Override
                public void verify(AbstractCalendarTest.TestCalendarListener calendarListener) {
                    Assert.assertEquals((String)"createdChangeExceptionInRecurringAppointment", (String)calendarListener.getCalledMethodName());
                    CalendarDataObject masterFromEvent = (CalendarDataObject)calendarListener.getArg(0);
                    CalendarDataObject changeExceptionFromEvent = (CalendarDataObject)calendarListener.getArg(1);
                    Assert.assertEquals((int)masterFromEvent.getObjectID(), (int)master.getObjectID());
                    Assert.assertEquals((int)masterFromEvent.getObjectID(), (int)changeExceptionFromEvent.getRecurrenceID());
                    changeExceptionId[0] = changeExceptionFromEvent.getObjectID();
                }
            });
            this.appointments.save(exception);
            Bug12377Test.assertEquals((int)exception.getObjectID(), (int)changeExceptionId[0]);
            Bug12377Test.assertTrue((String)"Callback was not triggered", (boolean)calendarListener.wasCalled());
        }
        finally {
            CalendarCallbacks.getInstance().removeListener((CalendarListener)calendarListener);
        }
    }
}

