/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.tests;

import com.openexchange.ajax.user.UserResolver;
import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.ICalUtils;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.jdom2.JDOMException;
import org.json.JSONException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FreeBusyTest
extends CalDAVTest {
    private String scheduleOutboxURL;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.scheduleOutboxURL = this.getScheduleOutboxURL();
    }

    public FreeBusyTest(String name) {
        super(name);
    }

    public void testDiscoverScheduleOutbox() throws Exception {
        FreeBusyTest.assertNotNull((String)"got no schedule-outbox URL", (Object)this.scheduleOutboxURL);
    }

    public void testFreeBusy() throws Exception {
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("midnight"));
        Date from = calendar.getTime();
        calendar.add(6, 1);
        Date until = calendar.getTime();
        calendar.setTime(from);
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            calendar.add(12, 1 + random.nextInt(60));
            Date start = calendar.getTime();
            calendar.add(12, 1 + random.nextInt(60));
            Date end = calendar.getTime();
            appointments.add(super.create(FreeBusyTest.generateAppointment(start, end, FreeBusyTest.randomUID(), "title" + i, "location" + i)));
        }
        ArrayList<String> attendees = new ArrayList<String>();
        attendees.add(super.getAJAXClient().getValues().getDefaultAddress());
        String freeBusyICal = this.generateFreeBusyICal(from, until, attendees);
        Document document = this.postFreeBusy(freeBusyICal, attendees);
        FreeBusyTest.assertNotNull((String)"got no free/busy result", (Object)document);
        List<FreeBusyResponse> freeBusyResponses = FreeBusyResponse.create(document);
        FreeBusyTest.assertEquals((String)"got invalid number of responses", (int)1, (int)freeBusyResponses.size());
        FreeBusyResponse freeBusyResponse = freeBusyResponses.get(0);
        FreeBusyTest.assertTrue((String)"recipient wrong", (null != freeBusyResponse.recipient && freeBusyResponse.recipient.contains((CharSequence)attendees.get(0)) ? 1 : 0) != 0);
        FreeBusyTest.assertEquals((String)"request status wrong", (String)"2.0;Success", (String)freeBusyResponse.requestStatus);
        FreeBusyTest.assertEquals((String)"response description wrong", (String)"OK", (String)freeBusyResponse.responseDescription);
        FreeBusyTest.assertNotNull((String)"got no claendar data", (Object)freeBusyResponse.calendarData);
        ICalResource iCalResource = new ICalResource(freeBusyResponse.calendarData);
        Map<String, List<FreeBusySlot>> freeBusy = this.extractFreeBusy(iCalResource);
        FreeBusyTest.assertEquals((String)"invalid number of attendees", (int)1, (int)freeBusy.size());
        List<FreeBusySlot> freeBusySlots = freeBusy.get(attendees.get(0));
        FreeBusyTest.assertNotNull((String)"no free/busy slots found", freeBusySlots);
        for (Appointment appointment : appointments) {
            FreeBusySlot matchingSlot = null;
            for (FreeBusySlot freeBusySlot : freeBusySlots) {
                if (!FreeBusyTest.matches(appointment, freeBusySlot)) continue;
                matchingSlot = freeBusySlot;
                break;
            }
            FreeBusyTest.assertNotNull((String)("no matching free/busy slot found for appointment " + appointment), (Object)matchingSlot);
        }
    }

    public void testFreeBusyTypes() throws Exception {
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        Appointment appointmentFree = CalDAVTest.generateAppointment(TimeTools.D("tomorrow at 2am"), TimeTools.D("tomorrow at 3am"), FreeBusyTest.randomUID(), "FREE", "location");
        appointmentFree.setShownAs(4);
        appointments.add(super.create(appointmentFree));
        Appointment appointmentAbsent = CalDAVTest.generateAppointment(TimeTools.D("tomorrow at 4am"), TimeTools.D("tomorrow at 5am"), FreeBusyTest.randomUID(), "ABSENT", "location");
        appointmentAbsent.setShownAs(3);
        appointments.add(super.create(appointmentAbsent));
        Appointment appointmentTemporary = CalDAVTest.generateAppointment(TimeTools.D("tomorrow at 6am"), TimeTools.D("tomorrow at 7am"), FreeBusyTest.randomUID(), "TEMPORARY", "location");
        appointmentTemporary.setShownAs(2);
        appointments.add(super.create(appointmentTemporary));
        Appointment appointmentReserved = CalDAVTest.generateAppointment(TimeTools.D("tomorrow at 9am"), TimeTools.D("tomorrow at 10am"), FreeBusyTest.randomUID(), "RESERVED", "location");
        appointmentReserved.setShownAs(1);
        appointments.add(super.create(appointmentReserved));
        ArrayList<String> attendees = new ArrayList<String>();
        attendees.add(super.getAJAXClient().getValues().getDefaultAddress());
        String freeBusyICal = this.generateFreeBusyICal(TimeTools.D("midnight"), TimeTools.D("tomorrow at midnight"), attendees);
        Document document = this.postFreeBusy(freeBusyICal, attendees);
        FreeBusyTest.assertNotNull((String)"got no free/busy result", (Object)document);
        List<FreeBusyResponse> freeBusyResponses = FreeBusyResponse.create(document);
        FreeBusyTest.assertEquals((String)"got invalid number of responses", (int)1, (int)freeBusyResponses.size());
        FreeBusyResponse freeBusyResponse = freeBusyResponses.get(0);
        FreeBusyTest.assertTrue((String)"recipient wrong", (null != freeBusyResponse.recipient && freeBusyResponse.recipient.contains((CharSequence)attendees.get(0)) ? 1 : 0) != 0);
        FreeBusyTest.assertEquals((String)"request status wrong", (String)"2.0;Success", (String)freeBusyResponse.requestStatus);
        FreeBusyTest.assertEquals((String)"response description wrong", (String)"OK", (String)freeBusyResponse.responseDescription);
        FreeBusyTest.assertNotNull((String)"got no claendar data", (Object)freeBusyResponse.calendarData);
        ICalResource iCalResource = new ICalResource(freeBusyResponse.calendarData);
        Map<String, List<FreeBusySlot>> freeBusy = this.extractFreeBusy(iCalResource);
        FreeBusyTest.assertEquals((String)"invalid number of attendees", (int)1, (int)freeBusy.size());
        List<FreeBusySlot> freeBusySlots = freeBusy.get(attendees.get(0));
        FreeBusyTest.assertNotNull((String)"no free/busy slots found", freeBusySlots);
        for (Appointment appointment : appointments) {
            FreeBusySlot matchingSlot = null;
            for (FreeBusySlot freeBusySlot : freeBusySlots) {
                if (!FreeBusyTest.matches(appointment, freeBusySlot)) continue;
                matchingSlot = freeBusySlot;
                break;
            }
            FreeBusyTest.assertNotNull((String)("no matching free/busy slot found for appointment " + appointment), (Object)matchingSlot);
        }
    }

    private Map<String, List<FreeBusySlot>> extractFreeBusy(ICalResource iCalResource) throws ParseException {
        HashMap<String, List<FreeBusySlot>> freeBusy = new HashMap<String, List<FreeBusySlot>>();
        FreeBusyTest.assertNotNull((String)"No VFREEBUSY in iCal found", iCalResource.getVFreeBusys());
        for (SimpleICal.Component freeBusyComponent : iCalResource.getVFreeBusys()) {
            SimpleICal.Property attendee = freeBusyComponent.getProperty("ATTENDEE");
            FreeBusyTest.assertNotNull((String)"VFREEBUSY without ATTENDEE", (Object)attendee);
            ArrayList<FreeBusySlot> freeBusySlots = new ArrayList<FreeBusySlot>();
            List<SimpleICal.Property> properties = freeBusyComponent.getProperties("FREEBUSY");
            for (SimpleICal.Property property : properties) {
                String fbType = property.getAttribute("FBTYPE");
                List<Date[]> periods = ICalUtils.parsePeriods(property);
                for (Date[] dates : periods) {
                    freeBusySlots.add(new FreeBusySlot(dates[0], dates[1], fbType));
                }
            }
            String mail = attendee.getValue();
            if (mail.startsWith("mailto:")) {
                mail = mail.substring(7);
            }
            freeBusy.put(mail, freeBusySlots);
        }
        return freeBusy;
    }

    private static boolean matches(Appointment appointment, FreeBusySlot freeBusySlot) {
        if (freeBusySlot.start.equals(appointment.getStartDate()) && freeBusySlot.end.equals(appointment.getEndDate())) {
            if (4 == appointment.getShownAs()) {
                return "FREE".equals(freeBusySlot.fbType);
            }
            if (3 == appointment.getShownAs()) {
                return "BUSY-UNAVAILABLE".equals(freeBusySlot.fbType);
            }
            if (2 == appointment.getShownAs()) {
                return "BUSY-TENTATIVE".equals(freeBusySlot.fbType);
            }
            return "BUSY".equals(freeBusySlot.fbType);
        }
        return false;
    }

    private Document postFreeBusy(String freeBusyICal, List<String> recipients) throws Exception {
        PostMethod post = new PostMethod(super.getWebDAVClient().getBaseURI() + this.scheduleOutboxURL);
        post.addRequestHeader("Originator", "mailto:" + super.getAJAXClient().getValues().getDefaultAddress());
        if (null != recipients && 0 < recipients.size()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("mailto:").append(recipients.get(0));
            for (int i = 0; i < recipients.size(); ++i) {
                stringBuilder.append(", ").append("mailto:").append(recipients.get(i));
            }
            post.addRequestHeader("Recipient", stringBuilder.toString());
        }
        post.setRequestEntity((RequestEntity)new StringRequestEntity(freeBusyICal, "text/calendar", null));
        String response = super.getWebDAVClient().doPost(post);
        FreeBusyTest.assertNotNull((String)"got no response", (Object)response);
        return DomUtil.parseDocument((InputStream)new ByteArrayInputStream(response.getBytes()));
    }

    private String getScheduleOutboxURL() throws Exception {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.PRINCIPAL_URL);
        PropFindMethod propFind = new PropFindMethod(this.getWebDAVClient().getBaseURI() + "/", 0, props, 0);
        MultiStatusResponse[] responses = this.getWebDAVClient().doPropFind(propFind);
        FreeBusyTest.assertNotNull((String)"got no response", (Object)responses);
        FreeBusyTest.assertTrue((String)"got no responses", (1 == responses.length ? 1 : 0) != 0);
        String principalURL = this.extractHref(PropertyNames.PRINCIPAL_URL, responses[0]);
        FreeBusyTest.assertNotNull((String)"got no principal URL", (Object)principalURL);
        props = new DavPropertyNameSet();
        props.add(PropertyNames.SCHEDULE_OUTBOX_URL);
        propFind = new PropFindMethod(this.getWebDAVClient().getBaseURI() + principalURL, 0, props, 0);
        responses = this.getWebDAVClient().doPropFind(propFind);
        FreeBusyTest.assertNotNull((String)"got no response", (Object)responses);
        FreeBusyTest.assertTrue((String)"got no responses", (1 == responses.length ? 1 : 0) != 0);
        String scheduleOutboxURL = this.extractHref(PropertyNames.SCHEDULE_OUTBOX_URL, responses[0]);
        FreeBusyTest.assertNotNull((String)"got no schedule-outbox URL", (Object)scheduleOutboxURL);
        return scheduleOutboxURL;
    }

    protected String generateFreeBusyICal(Date from, Date until, List<String> attendees) throws OXException, IOException, JSONException {
        String organizerMail = new UserResolver(this.getAJAXClient()).getUser(this.getAJAXClient().getValues().getUserId()).getMail();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BEGIN:VCALENDAR").append("\r\n").append("CALSCALE:GREGORIAN").append("\r\n").append("VERSION:2.0").append("\r\n").append("METHOD:REQUEST").append("\r\n").append("PRODID:-//Apple Inc.//iCal 5.0.2//EN").append("\r\n").append("BEGIN:VFREEBUSY").append("\r\n").append("UID:").append(FreeBusyTest.randomUID()).append("\r\n").append("DTEND:").append(FreeBusyTest.formatAsUTC(until)).append("\r\n");
        for (String attendee : attendees) {
            stringBuilder.append("ATTENDEE:mailto:").append(attendee).append("\r\n");
        }
        stringBuilder.append("DTSTART:").append(FreeBusyTest.formatAsUTC(from)).append("\r\n").append("X-CALENDARSERVER-MASK-UID:").append(FreeBusyTest.randomUID()).append("\r\n").append("DTSTAMP:").append(FreeBusyTest.formatAsUTC(new Date())).append("\r\n").append("ORGANIZER:mailto:").append(organizerMail).append("\r\n").append("END:VFREEBUSY").append("\r\n").append("END:VCALENDAR").append("\r\n");
        return stringBuilder.toString();
    }

    private static final class FreeBusySlot {
        public Date start;
        public Date end;
        public String fbType;

        public FreeBusySlot(Date start, Date end, String fbType) {
            this.start = start;
            this.end = end;
            this.fbType = fbType;
        }
    }

    private static final class FreeBusyResponse {
        public String recipient;
        public String requestStatus;
        public String responseDescription;
        public String calendarData;

        private FreeBusyResponse() {
        }

        public static List<FreeBusyResponse> create(Document document) throws JDOMException {
            ArrayList<FreeBusyResponse> fbResponses = new ArrayList<FreeBusyResponse>();
            NodeList nodes = document.getElementsByTagNameNS(PropertyNames.RESPONSE_CALDAV.getNamespace().getURI(), PropertyNames.RESPONSE_CALDAV.getName());
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                fbResponses.add(FreeBusyResponse.create(element));
            }
            return fbResponses;
        }

        public static FreeBusyResponse create(Element response) throws JDOMException {
            FreeBusyResponse fbResponse = new FreeBusyResponse();
            fbResponse.recipient = FreeBusyTest.extractChildTextContent(PropertyNames.HREF, response);
            fbResponse.requestStatus = FreeBusyTest.extractChildTextContent(PropertyNames.REQUEST_STATUS, response);
            fbResponse.responseDescription = FreeBusyTest.extractChildTextContent(PropertyNames.RESPONSEDESCRIPTION, response);
            fbResponse.calendarData = FreeBusyTest.extractChildTextContent(PropertyNames.CALENDAR_DATA, response);
            return fbResponse;
        }
    }
}

