/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.test;

import com.openexchange.ajax.subscribe.actions.UpdateSubscriptionResponse;
import com.openexchange.ajax.subscribe.test.AbstractSubscriptionTest;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.subscribe.SimSubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class UpdateSubscriptionTest
extends AbstractSubscriptionTest {
    public UpdateSubscriptionTest(String name) {
        super(name);
    }

    public void testUpdatingAnExistingValueWithinAnOMXFSubscription() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.createDefaultContactFolder();
        DynamicFormDescription formDescription = this.generateFormDescription();
        Subscription expected = this.generateOXMFSubscription(formDescription);
        expected.setFolderId(folder.getObjectID());
        this.subMgr.setFormDescription(formDescription);
        SimSubscriptionSourceDiscoveryService discovery = new SimSubscriptionSourceDiscoveryService();
        discovery.addSource(expected.getSource());
        this.subMgr.setSubscriptionSourceDiscoveryService((SubscriptionSourceDiscoveryService)discovery);
        this.subMgr.newAction(expected);
        UpdateSubscriptionTest.assertFalse((String)"Precondition: Creation of subscription should work", (boolean)this.subMgr.getLastResponse().hasError());
        expected.getConfiguration().put("url", "http://ox.open-exchange.com/2");
        this.subMgr.updateAction(expected);
        UpdateSubscriptionTest.assertTrue((String)"Should return 1 if update worked", (boolean)((UpdateSubscriptionResponse)this.subMgr.getLastResponse()).wasSuccessful());
        Subscription actual = this.subMgr.getAction(expected.getId());
        UpdateSubscriptionTest.assertEquals((String)"Should contain the same url in the configuration", expected.getConfiguration().get("url"), actual.getConfiguration().get("url"));
    }

    public void testUpdatingAnOMXFSubscriptionWithANewValue() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.createDefaultContactFolder();
        DynamicFormDescription formDescription = this.generateFormDescription();
        Subscription expected = this.generateOXMFSubscription(formDescription);
        expected.setFolderId(folder.getObjectID());
        this.subMgr.setFormDescription(formDescription);
        SimSubscriptionSourceDiscoveryService discovery = new SimSubscriptionSourceDiscoveryService();
        discovery.addSource(expected.getSource());
        this.subMgr.setSubscriptionSourceDiscoveryService((SubscriptionSourceDiscoveryService)discovery);
        this.subMgr.newAction(expected);
        UpdateSubscriptionTest.assertFalse((String)"Precondition: Creation of subscription should work", (boolean)this.subMgr.getLastResponse().hasError());
        expected.getConfiguration().put("username", "Elvis Aaron Presley");
        this.subMgr.updateAction(expected);
        UpdateSubscriptionTest.assertTrue((String)"Should return 1 if update worked", (boolean)((UpdateSubscriptionResponse)this.subMgr.getLastResponse()).wasSuccessful());
        Subscription actual = this.subMgr.getAction(expected.getId());
        UpdateSubscriptionTest.assertEquals((String)"Should not take a value that was not defined in the form description", null, actual.getConfiguration().get("username"));
    }
}

