/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.Login;
import com.openexchange.ajax.session.AbstractLoginTest;
import java.util.Arrays;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;

public class AutologinTest
extends AbstractLoginTest {
    public AutologinTest(String name) {
        super(name);
    }

    public void testGeeIForgotMySessionIDCanYouGiveItBack() throws Exception {
        this.as("login");
        this.inModule("login");
        this.call("store", new Object[0]);
        String sessionID = this.currentClient.getSessionID();
        this.forgetSession();
        this.raw("autologin", new Object[0]);
        for (String key : Arrays.asList("session", "random")) {
            AutologinTest.assertTrue((String)("Missing key: " + key), (boolean)this.rawResponse.has(key));
        }
        AutologinTest.assertEquals((String)sessionID, (String)this.rawResponse.getString("session"));
        this.inModule("quota");
        this.call("filestore", "session", sessionID);
        this.assertNoError();
    }

    public void testRetrieveSessionIDForCertainClient() throws Exception {
        this.createClient();
        this.inModule("login");
        String[] credentials = this.credentials("login");
        this.raw("login", "name", credentials[0], "password", credentials[1], "client", "testclient1");
        String sessionID = this.rawResponse.getString("session");
        this.call("store", "session", sessionID);
        this.forgetSession();
        this.raw("autologin", "client", "testclient1");
        AutologinTest.assertEquals((Object)sessionID, (Object)this.rawResponse.get("session"));
    }

    public void testUnknownSession() throws Exception {
        this.as("login");
        this.inModule("login");
        this.call("store", new Object[0]);
        HttpState state = this.currentClient.getClient().getState();
        Cookie[] cookies = state.getCookies();
        boolean replaced = false;
        for (Cookie cookie : cookies) {
            if (!cookie.getName().startsWith(Login.SESSION_PREFIX)) continue;
            cookie.setValue("1234567");
            state.addCookie(cookie);
            replaced = true;
            break;
        }
        AutologinTest.assertTrue((String)"Could not find session cookie", (boolean)replaced);
        this.forgetSession();
        this.call("autologin", new Object[0]);
        this.assertError();
        this.assertNoOXCookies();
    }

    public void testSessionAndSecretMismatch() throws Exception {
        this.as("login");
        String sessionID = this.currentClient.getSessionID();
        this.as("seconduser");
        this.inModule("login");
        this.call("store", new Object[0]);
        HttpState state = this.currentClient.getClient().getState();
        Cookie[] cookies = state.getCookies();
        boolean replaced = false;
        for (Cookie cookie : cookies) {
            if (!cookie.getName().startsWith(Login.SESSION_PREFIX)) continue;
            cookie.setValue(sessionID);
            state.addCookie(cookie);
            replaced = true;
            break;
        }
        AutologinTest.assertTrue((String)"Could not find session cookie", (boolean)replaced);
        this.forgetSession();
        this.call("autologin", new Object[0]);
        this.assertError();
        this.assertNoOXCookies();
    }

    private void forgetSession() {
        this.currentClient.setSessionID(null);
    }
}

