/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.reminder.actions.AbstractReminderRequest;
import com.openexchange.ajax.reminder.actions.DeleteParser;
import com.openexchange.groupware.reminder.ReminderObject;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeleteRequest
extends AbstractReminderRequest<CommonDeleteResponse> {
    private final ReminderObject reminder;
    private final ReminderObject[] reminders;
    private final boolean failOnError;

    public DeleteRequest(ReminderObject reminder, boolean failOnError) {
        this.reminder = reminder;
        this.reminders = null;
        this.failOnError = failOnError;
    }

    public DeleteRequest(ReminderObject[] reminders, boolean failOnError) {
        this.reminder = null;
        this.reminders = reminders;
        this.failOnError = failOnError;
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        if (this.reminders == null) {
            JSONObject json = new JSONObject();
            json.put("recurrence_position", this.reminder.getRecurrencePosition());
            json.put("id", this.reminder.getObjectId());
            return json;
        }
        JSONArray jsonArray = new JSONArray();
        for (ReminderObject reminder : this.reminders) {
            JSONObject json = new JSONObject();
            json.put("recurrence_position", reminder.getRecurrencePosition());
            json.put("id", reminder.getObjectId());
            jsonArray.put((Object)json);
        }
        return jsonArray;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        if (this.reminders == null) {
            return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "delete"), new AJAXRequest.Parameter("timestamp", String.valueOf(this.reminder.getLastModified().getTime()))};
        }
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "delete"), new AJAXRequest.Parameter("timestamp", String.valueOf(this.reminders[0].getLastModified().getTime()))};
    }

    public DeleteParser getParser() {
        return new DeleteParser(this.failOnError);
    }
}

