/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.NewMailRequest;

public class CountMailTest
extends AbstractMailTest {
    public CountMailTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        this.clearFolder(this.getInboxFolder());
        super.tearDown();
    }

    public void testCounting() throws Exception {
        String inboxFolder = this.getInboxFolder();
        this.clearFolder(inboxFolder);
        CountMailTest.assertEquals((String)"Should be empty", (int)0, (int)this.count(inboxFolder));
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: #ADDR#\nTo: #ADDR#\nSubject: Invitation for launch\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nThis is a MIME message. If you are reading this text, you may want to \nconsider changing to a mail reader or gateway that understands how to \nproperly handle MIME multipart messages.".replaceAll("#ADDR#", this.getSendAddress());
        for (int number = 1; number < 10; ++number) {
            this.getClient().execute(new NewMailRequest(inboxFolder, eml, -1, true));
            CountMailTest.assertEquals((String)("Does not contain the expected number of elements in folder " + inboxFolder), (int)number, (int)this.count(inboxFolder));
        }
        this.clearFolder(inboxFolder);
        CountMailTest.assertEquals((String)"Should be empty again", (int)0, (int)this.count(inboxFolder));
    }
}

