/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreParser;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.groupware.infostore.DocumentMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NewInfostoreRequest
extends AbstractInfostoreRequest<NewInfostoreResponse> {
    private DocumentMetadata metadata;
    private final InputStream input;

    public NewInfostoreRequest() {
        this(null, (InputStream)null);
    }

    public NewInfostoreRequest(DocumentMetadata data) {
        this(data, (InputStream)null);
    }

    public NewInfostoreRequest(DocumentMetadata data, File upload) throws FileNotFoundException {
        this(data, new FileInputStream(upload));
    }

    public NewInfostoreRequest(DocumentMetadata data, InputStream input) {
        this.metadata = data;
        this.input = input;
    }

    public void setMetadata(DocumentMetadata metadata) {
        this.metadata = metadata;
    }

    public DocumentMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getBody() throws JSONException {
        JSONObject originalObject = new JSONObject(this.writeJSON(this.getMetadata()));
        JSONObject retVal = new JSONObject();
        Set set = originalObject.keySet();
        for (String string : set) {
            Object test = originalObject.get(string);
            if (test == JSONObject.NULL) continue;
            if (test instanceof JSONArray) {
                if (((JSONArray)test).length() <= 0) continue;
                retVal.put(string, test);
                continue;
            }
            retVal.put(string, test);
        }
        return retVal.toString();
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return null == this.input ? AJAXRequest.Method.PUT : AJAXRequest.Method.UPLOAD;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws JSONException {
        ArrayList<AJAXRequest.Parameter> tmp = new ArrayList<AJAXRequest.Parameter>(3);
        tmp.add(new AJAXRequest.Parameter("action", "new"));
        if (null != this.input) {
            tmp.add(new AJAXRequest.FieldParameter("json", this.getBody()));
            tmp.add(new AJAXRequest.FileParameter("file", this.metadata.getFileName(), this.input, this.metadata.getFileMIMEType()));
        }
        return tmp.toArray(new AJAXRequest.Parameter[tmp.size()]);
    }

    public NewInfostoreParser getParser() {
        return new NewInfostoreParser(this.getFailOnError(), null != this.input);
    }
}

