/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class AllTest
extends InfostoreAJAXTest {
    public AllTest(String name) {
        super(name);
    }

    public void testBasic() throws Exception {
        Response res = this.all(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{1, 700, 706, 701, 20});
        HashSet<String> descriptions = new HashSet<String>(Arrays.asList("test knowledge description", "test url description"));
        HashSet<String> urls = new HashSet<String>(Arrays.asList("http://www.open-xchange.com"));
        HashSet<String> titles = new HashSet<String>(Arrays.asList("test knowledge", "test url"));
        AllTest.assertNoError(res);
        JSONArray entries = (JSONArray)res.getData();
        for (int i = 0; i < entries.length(); ++i) {
            JSONArray entry = entries.getJSONArray(i);
            AllTest.assertTrue((boolean)titles.remove(entry.getString(1)));
            AllTest.assertTrue((boolean)descriptions.remove(entry.getString(2)));
            urls.remove(entry.getString(3));
        }
        AllTest.assertTrue((boolean)descriptions.isEmpty());
        AllTest.assertTrue((boolean)urls.isEmpty());
        AllTest.assertTrue((boolean)titles.isEmpty());
    }

    public void testVirtualFolder() throws Exception {
        for (int folderId : virtualFolders) {
            this.virtualFolderTest(folderId);
        }
    }

    public void virtualFolderTest(int folderid) throws JSONException, IOException, SAXException {
        Response res = this.all(this.getWebConversation(), this.getHostName(), this.sessionId, folderid, new int[]{1});
        AllTest.assertNoError(res);
        AllTest.assertEquals((int)0, (int)((JSONArray)res.getData()).length());
    }

    public void testLastModifiedUTC() throws Exception {
        Response res = this.all(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{6});
        AllTest.assertNoError(res);
        JSONArray entries = (JSONArray)res.getData();
        int size = entries.length();
        AllTest.assertTrue((size > 0 ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            JSONArray entry = entries.getJSONArray(i);
            AllTest.assertNotNull((Object)entry.get(0));
        }
    }

    public void testNumberOfVersions() throws JSONException, IOException, SAXException {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0), Long.MAX_VALUE, this.m("description", "New description"), upload, "text/plain");
        AllTest.assertNoError(res);
        res = this.all(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{1, 711});
        JSONArray rows = (JSONArray)res.getData();
        boolean found = false;
        int size = rows.length();
        for (int i = 0; i < size; ++i) {
            JSONArray row = rows.getJSONArray(i);
            int id = row.getInt(0);
            int numberOfVersions = row.getInt(1);
            if (id != (Integer)this.clean.get(0)) continue;
            AllTest.assertEquals((int)1, (int)numberOfVersions);
            found = true;
        }
        AllTest.assertTrue((boolean)found);
    }
}

