/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.importexport.actions.CSVExportRequest;
import com.openexchange.ajax.importexport.actions.CSVExportResponse;
import com.openexchange.ajax.importexport.actions.VCardExportRequest;
import com.openexchange.ajax.importexport.actions.VCardExportResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.importexport.csv.CSVParser;
import java.io.IOException;
import java.util.List;
import org.json.JSONException;

public class DistributionListExportTest
extends AbstractManagedContactTest {
    public DistributionListExportTest(String name) {
        super(name);
    }

    public void testCsvDistributionListsAreNotExported() throws OXException, IOException, JSONException {
        Contact list = this.generateContact("Distribution list");
        list.setDistributionList(new DistributionListEntryObject[]{new DistributionListEntryObject("my displayname", "myemail@adress.invalid", 0)});
        this.manager.newAction(list);
        CSVExportResponse csvExportResponse = this.client.execute(new CSVExportRequest(this.folderID));
        String csvStr = (String)csvExportResponse.getData();
        CSVParser csvParser = new CSVParser(csvStr);
        List csv = csvParser.parse();
        DistributionListExportTest.assertEquals((String)"Should only contain the header line but no content", (int)1, (int)csv.size());
    }

    public void testVCardDistributionListsAreNotExported() throws OXException, IOException, JSONException {
        Contact list = this.generateContact("Distribution list is not present");
        list.setDistributionList(new DistributionListEntryObject[]{new DistributionListEntryObject("my displayname", "myemail@adress.invalid", 0)});
        this.manager.newAction(list);
        VCardExportResponse vcardExportResponse = this.client.execute(new VCardExportRequest(this.folderID, false));
        String vcard = (String)vcardExportResponse.getData();
        DistributionListExportTest.assertFalse((String)"Should not contain name of contact in list", (boolean)vcard.contains("my displayname"));
        DistributionListExportTest.assertFalse((String)"Should not contain e-mail of contact in list", (boolean)vcard.contains("myemail@adress.invalid"));
        DistributionListExportTest.assertFalse((String)"Should not contain name of distribution list", (boolean)vcard.contains("Distribution list is not present"));
    }
}

