/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact.action;

import com.openexchange.ajax.contact.action.AbstractContactRequest;
import com.openexchange.ajax.contact.action.UpdateParser;
import com.openexchange.ajax.contact.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.groupware.container.Contact;
import java.io.ByteArrayInputStream;
import org.json.JSONException;

public class UpdateRequest
extends AbstractContactRequest<UpdateResponse> {
    private final Contact contactObj;
    private final boolean failOnError;
    private final int originFolder;
    private final boolean withImage;
    private String fieldContent;

    public UpdateRequest(Contact contactObj) {
        this(contactObj, true);
    }

    public UpdateRequest(Contact contactObj, boolean failOnError) {
        this(contactObj.getParentFolderID(), contactObj, failOnError);
    }

    public UpdateRequest(int inFolder, Contact entry, boolean failOnError) {
        this.contactObj = entry;
        this.failOnError = failOnError;
        this.originFolder = inFolder;
        boolean bl = this.withImage = this.contactObj.containsImage1() && null != this.contactObj.getImage1();
        if (this.withImage) {
            try {
                this.fieldContent = this.convert(this.contactObj).toString();
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Override
    public Object getBody() throws JSONException {
        return this.convert(this.contactObj);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return this.withImage ? AJAXRequest.Method.UPLOAD : AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        if (this.withImage) {
            return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "update"), new AJAXRequest.Parameter("folder", Integer.toString(this.originFolder)), new AJAXRequest.Parameter("id", Integer.toString(this.contactObj.getObjectID())), new AJAXRequest.Parameter("timestamp", Long.toString(this.contactObj.getLastModified().getTime())), new AJAXRequest.FieldParameter("json", this.fieldContent), new AJAXRequest.FileParameter("file", "open-xchange_image.jpg", new ByteArrayInputStream(this.contactObj.getImage1()), "image/jpg")};
        }
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "update"), new AJAXRequest.Parameter("folder", Integer.toString(this.originFolder)), new AJAXRequest.Parameter("id", Integer.toString(this.contactObj.getObjectID())), new AJAXRequest.Parameter("timestamp", Long.toString(this.contactObj.getLastModified().getTime()))};
    }

    public UpdateParser getParser() {
        return new UpdateParser(this.failOnError, this.withImage);
    }

    protected Contact getContact() {
        return this.contactObj;
    }
}

