/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.meterware.httpunit.WebConversation;
import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bug9742Test
extends AbstractAJAXSession {
    private static final Log LOG = LogFactory.getLog(Bug9742Test.class);
    public static final int[] APPOINTMENT_FIELDS = new int[]{1, 2, 4, 5, 3, 20, 101, 100, 200, 201, 202, 400, 203, 209, 220, 221, 402, 401, 102};

    public Bug9742Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testDummy() {
    }

    public void testBug9742() throws Exception {
        AJAXSession ajaxSession = this.getSession();
        AJAXClient ajaxClient = this.getClient();
        TimeZone timeZone = ajaxClient.getValues().getTimeZone();
        if (!timeZone.getID().equals("Europe/Berlin")) {
            ajaxClient.getValues().setTimeZone(TimeZone.getTimeZone("America/New_York"));
        }
        timeZone = ajaxClient.getValues().getTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.add(5, 1);
        calendar.set(11, 10);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date startDate = calendar.getTime();
        calendar.add(11, 2);
        Date endDate = calendar.getTime();
        int appointmentFolderId = ajaxClient.getValues().getPrivateAppointmentFolder();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug9742");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setRecurrenceCount(5);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setTimezone("Europe/Berlin");
        Calendar calendarRange = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendarRange.add(14, timeZone.getOffset(calendarRange.getTimeInMillis()));
        calendarRange.set(11, 0);
        calendarRange.set(12, 0);
        calendarRange.set(13, 0);
        calendarRange.set(14, 0);
        Date start = calendarRange.getTime();
        calendarRange.add(5, 5);
        Date end = calendarRange.getTime();
        InsertRequest insertRequest = new InsertRequest(appointmentObj, timeZone, true);
        CommonInsertResponse insertResponse = Executor.execute(ajaxSession, insertRequest);
        int objectId = insertResponse.getId();
        String hostname = AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME);
        WebConversation webCon = ajaxSession.getConversation();
        Appointment loadAppointment = AppointmentTest.loadAppointment(webCon, objectId, appointmentFolderId, timeZone, hostname, ajaxSession.getId());
        Date modified = loadAppointment.getLastModified();
        Appointment[] appointmentArray = AppointmentTest.listAppointment(webCon, appointmentFolderId, APPOINTMENT_FIELDS, start, end, timeZone, false, hostname, ajaxSession.getId());
        int appointmentCounter = 0;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            ++appointmentCounter;
        }
        Bug9742Test.assertEquals((String)"unexpected appointments size", (int)4, (int)appointmentCounter);
        DeleteRequest deleteRequest = new DeleteRequest(objectId, appointmentFolderId, modified);
        Executor.execute(ajaxSession, deleteRequest);
    }
}

