/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.appointment.recurrence.Occurrence;
import com.openexchange.test.OXTestToolkit;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;

public class AbstractRecurrenceTest
extends AppointmentTest {
    protected static final TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
    protected SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected SimpleDateFormat simpleDateFormatUTC = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static final Log LOG = LogFactory.getLog(AbstractRecurrenceTest.class);
    protected static final int[] _fields = new int[]{1, 2, 4, 5, 3, 20, 101, 100, 200, 400, 201, 202, 203, 209, 402, 401, 102, 207, 408};

    public AbstractRecurrenceTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.simpleDateFormatUTC.setTimeZone(timeZoneUTC);
        this.simpleDateFormat.setTimeZone(this.timeZone);
    }

    protected Occurrence getOccurrenceByPosition(Occurrence[] occurrenceArray, int position) {
        for (int a = 0; a < occurrenceArray.length; ++a) {
            if (occurrenceArray[a].getPosition() != position) continue;
            return occurrenceArray[a];
        }
        return null;
    }

    public static void assertOccurrence(int expectedPosition, Date expectedStartDate, Date expectedEndDate, Occurrence occurrence) throws Exception {
        AbstractRecurrenceTest.assertOccurrence(expectedPosition, expectedStartDate, expectedEndDate, occurrence, timeZoneUTC);
    }

    public static void assertOccurrence(int expectedPosition, Date expectedStartDate, Date expectedEndDate, Occurrence occurrence, TimeZone timeZone) throws Exception {
        AbstractRecurrenceTest.assertNotNull((String)"occurrence is null", (Object)occurrence);
        AbstractRecurrenceTest.assertEquals((String)"position is not equals", (int)expectedPosition, (int)occurrence.getPosition());
        OXTestToolkit.assertEqualsAndNotNull("start date is not equals at position: " + expectedPosition, AbstractRecurrenceTest.addOffsetToDate(expectedStartDate, timeZone), AbstractRecurrenceTest.addOffsetToDate(occurrence.getStartDate(), timeZone));
        OXTestToolkit.assertEqualsAndNotNull("end date is not equals at position: " + expectedPosition, AbstractRecurrenceTest.addOffsetToDate(expectedEndDate, timeZone), AbstractRecurrenceTest.addOffsetToDate(occurrence.getEndDate(), timeZone));
    }

    public static Date addOffsetToDate(Date value, TimeZone timeZone) throws JSONException {
        int offset = timeZone.getOffset(value.getTime());
        return new Date(value.getTime() + (long)offset);
    }
}

