/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import java.util.Calendar;
import java.util.TimeZone;

public class Bug15590Test
extends AbstractAJAXSession {
    AJAXClient secondClient;
    FolderObject testFolder;
    Appointment testAppointment;
    Appointment movedAppointment;
    UserValues secondUserValues;

    public Bug15590Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.secondClient = new AJAXClient(AJAXClient.User.User2);
        this.secondUserValues = this.secondClient.getValues();
        this.testFolder = Create.createPrivateFolder("bug15590folder", 2, this.client.getValues().getUserId());
        this.testFolder.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        com.openexchange.ajax.folder.actions.InsertRequest insFolder = new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_NEW, this.testFolder);
        InsertResponse folderInsertResponse = this.client.execute(insFolder);
        this.testFolder.setObjectID(folderInsertResponse.getId());
        this.testFolder.setLastModified(this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, this.testFolder.getObjectID())).getTimestamp());
        FolderTools.shareFolder(this.client, EnumAPI.OX_NEW, this.testFolder.getObjectID(), this.secondUserValues.getUserId(), 4, 128, 128, 128);
        this.testAppointment = new Appointment();
        this.testAppointment.setTitle("testBug15590");
        Calendar calendar = TimeTools.createCalendar(this.secondUserValues.getTimeZone());
        calendar.add(5, 1);
        this.testAppointment.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        this.testAppointment.setEndDate(calendar.getTime());
        this.testAppointment.setShownAs(1);
        this.testAppointment.setPrivateFlag(false);
        this.testAppointment.setParentFolderID(this.secondUserValues.getPrivateAppointmentFolder());
        this.testAppointment.setRecurrenceType(0);
        this.testAppointment.setIgnoreConflicts(true);
        this.testAppointment.setAlarm(15);
        AppointmentInsertResponse insertR = this.secondClient.execute(new InsertRequest(this.testAppointment, TimeZone.getDefault()));
        insertR.fillAppointment(this.testAppointment);
    }

    public void testBug15590() throws Exception {
        Appointment moveAppointment = new Appointment();
        moveAppointment.setIgnoreConflicts(true);
        moveAppointment.setObjectID(this.testAppointment.getObjectID());
        moveAppointment.setParentFolderID(this.testFolder.getObjectID());
        moveAppointment.setLastModified(this.testAppointment.getLastModified());
        UpdateRequest moveReq = new UpdateRequest(this.secondUserValues.getPrivateAppointmentFolder(), moveAppointment, TimeZone.getDefault(), true);
        UpdateResponse updateResponse = this.secondClient.execute(moveReq);
        updateResponse.fillObject((DataObject)this.testAppointment);
        com.openexchange.ajax.appointment.action.GetRequest getMovedAppointmentRequest = new com.openexchange.ajax.appointment.action.GetRequest(moveAppointment);
        GetResponse getMovedAppointmentResponse = this.secondClient.execute(getMovedAppointmentRequest);
        this.movedAppointment = getMovedAppointmentResponse.getAppointment(TimeZone.getDefault());
        Bug15590Test.assertEquals((int)this.movedAppointment.getParentFolderID(), (int)moveAppointment.getParentFolderID());
    }

    @Override
    public void tearDown() throws Exception {
        if (this.movedAppointment != null) {
            this.secondClient.execute(new com.openexchange.ajax.appointment.action.DeleteRequest(this.movedAppointment));
        } else if (this.testAppointment != null) {
            com.openexchange.ajax.appointment.action.DeleteRequest delApp = new com.openexchange.ajax.appointment.action.DeleteRequest(this.testAppointment.getObjectID(), this.testFolder.getObjectID(), this.testAppointment.getLastModified());
            this.secondClient.execute(delApp);
        }
        if (this.secondClient != null) {
            this.secondClient.logout();
        }
        if (this.testFolder != null) {
            DeleteRequest delFolder = new DeleteRequest((API)EnumAPI.OX_NEW, this.testFolder);
            this.client.execute(delFolder);
        }
        super.tearDown();
    }
}

