/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.action;

import com.openexchange.ajax.appointment.action.AbstractAppointmentRequest;
import com.openexchange.ajax.appointment.action.DeleteParser;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeleteRequest
extends AbstractAppointmentRequest<CommonDeleteResponse> {
    private final int objectId;
    private final int[] objectIds;
    private final int inFolder;
    private final int recurrencePosition;
    private final Date lastModified;
    private boolean failOnError = true;
    private Date recurrenceDatePosition;

    public DeleteRequest(int objectId, int inFolder, Date lastModified, boolean failOnError) {
        this(objectId, inFolder, 0, lastModified, failOnError);
    }

    public DeleteRequest(int[] objectIds, int inFolder, Date lastModified, boolean failOnError) {
        this(objectIds, inFolder, 0, lastModified, failOnError);
    }

    public DeleteRequest(int objectId, int inFolder, Date lastModified) {
        this(objectId, inFolder, 0, lastModified, true);
    }

    public DeleteRequest(Appointment appointment) {
        this(appointment.getObjectID(), appointment.getParentFolderID(), appointment.getLastModified());
    }

    public DeleteRequest(Appointment appointment, boolean failOnError) {
        this(appointment.getObjectID(), appointment.getParentFolderID(), appointment.getLastModified(), failOnError);
    }

    public DeleteRequest(int objectId, int inFolder, int recurrencePosition, Date lastModified) {
        this(objectId, inFolder, recurrencePosition, lastModified, true);
    }

    public DeleteRequest(int objectId, int inFolder, int recurrencePosition, Date lastModified, boolean failOnError) {
        this.objectId = objectId;
        this.objectIds = null;
        this.inFolder = inFolder;
        this.recurrencePosition = recurrencePosition;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
    }

    public DeleteRequest(int[] objectIds, int inFolder, int recurrencePosition, Date lastModified, boolean failOnError) {
        this.objectId = 0;
        this.objectIds = objectIds;
        this.inFolder = inFolder;
        this.recurrencePosition = recurrencePosition;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
    }

    public DeleteRequest(int objectId, int inFolder, Date recurrenceDatePosition, Date lastModified) {
        this(objectId, inFolder, recurrenceDatePosition, lastModified, true);
    }

    public DeleteRequest(int objectId, int inFolder, Date recurrenceDatePosition, Date lastModified, boolean failOnError) {
        this.objectId = objectId;
        this.objectIds = null;
        this.inFolder = inFolder;
        this.recurrencePosition = -1;
        this.recurrenceDatePosition = recurrenceDatePosition;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
    }

    public DeleteRequest(int[] objectIds, int inFolder, Date recurrenceDatePosition, Date lastModified, boolean failOnError) {
        this.objectId = 0;
        this.objectIds = objectIds;
        this.inFolder = inFolder;
        this.recurrencePosition = -1;
        this.recurrenceDatePosition = recurrenceDatePosition;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public Object getBody() throws JSONException {
        if (this.objectIds == null) {
            JSONObject json = new JSONObject();
            json.put("id", this.objectId);
            json.put("folder", this.inFolder);
            if (this.recurrencePosition > 0) {
                json.put("recurrence_position", this.recurrencePosition);
            } else if (this.recurrenceDatePosition != null) {
                json.put("recurrence_date_position", this.recurrenceDatePosition.getTime());
            }
            return json;
        }
        JSONArray jsonArray = new JSONArray();
        for (int id : this.objectIds) {
            JSONObject json = new JSONObject();
            json.put("id", id);
            json.put("folder", this.inFolder);
            if (this.recurrencePosition > 0) {
                json.put("recurrence_position", this.recurrencePosition);
            } else if (this.recurrenceDatePosition != null) {
                json.put("recurrence_date_position", this.recurrenceDatePosition.getTime());
            }
            jsonArray.put((Object)json);
        }
        return jsonArray;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "delete"), new AJAXRequest.Parameter("timestamp", String.valueOf(this.lastModified.getTime()))};
    }

    public DeleteParser getParser() {
        return new DeleteParser(this.failOnError);
    }
}

