/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteTest
extends AppointmentTest {
    private static final Log LOG = LogFactory.getLog(DeleteTest.class);

    public DeleteTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testDelete() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testDelete");
        appointmentObj.setIgnoreConflicts(true);
        DeleteTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        int id = DeleteTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        DeleteTest.deleteAppointment(this.getWebConversation(), id, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), true);
        try {
            DeleteTest.deleteAppointment(this.getWebConversation(), id, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
            DeleteTest.fail((String)"OXObjectNotFoundException expected!");
        }
        catch (Exception ex) {
            DeleteTest.assertTrue((boolean)true);
        }
    }

    public void testDeleteRecurrenceWithPosition() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 1296000000L);
        int changeExceptionPosition = 3;
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDeleteRecurrenceWithPosition");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = DeleteTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = DeleteTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        appointmentObj = new Appointment();
        appointmentObj.setTitle("testDeleteRecurrenceWithPosition - exception");
        appointmentObj.setStartDate(new Date(startTime + 3600000L));
        appointmentObj.setEndDate(new Date(endTime + 3600000L));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrencePosition(3);
        appointmentObj.setIgnoreConflicts(true);
        int newObjectId = DeleteTest.updateAppointment(this.getWebConversation(), appointmentObj, objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(newObjectId);
        DeleteTest.assertFalse((String)"object id of the update is equals with the old object id", (newObjectId == objectId ? 1 : 0) != 0);
        loadAppointment = DeleteTest.loadAppointment(this.getWebConversation(), newObjectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, appointmentObj.getStartDate().getTime(), appointmentObj.getEndDate().getTime());
        loadAppointment = DeleteTest.loadAppointment(this.getWebConversation(), newObjectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, appointmentObj.getStartDate().getTime(), appointmentObj.getEndDate().getTime());
        DeleteTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), true);
    }

    public void testDeleteRecurrenceWithDate() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 1296000000L);
        int changeExceptionPosition = 3;
        Date exceptionDate = new Date(c.getTimeInMillis() + 259200000L);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDeleteRecurrenceWithDate");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = DeleteTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = DeleteTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        DeleteTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, exceptionDate, new Date(Long.MAX_VALUE), "http://" + this.getHostName(), this.getSessionId(), true);
        loadAppointment = DeleteTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        DeleteTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), true);
    }
}

