/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.parser.ContactParser;
import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.user.UserTools;
import com.openexchange.ajax.writer.ContactWriter;
import com.openexchange.contact.Data;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.LinkEntryObject;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.java.Charsets;
import com.openexchange.test.OXTestToolkit;
import com.openexchange.test.TestException;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class ContactTest
extends AbstractAJAXTest {
    protected static final int[] CONTACT_FIELDS = new int[]{1, 2, 4, 5, 3, 20, 100, 501, 502, 517, 537, 511, 533, 534, 551, 552, 526, 508, 539, 102, 532, 569, 528, 510, 541, 519, 500, 592, 555, 556, 557, 521, 544, 550, 554, 535, 565, 566, 570, 591, 536, 512, 503, 515, 518, 513, 529, 520, 525, 507, 540, 101, 514, 522, 530, 516, 527, 509, 598, 523, 506, 538, 504, 531, 568, 542, 543, 545, 546, 547, 548, 549, 567, 559, 553, 560, 561, 562, 563, 564, 505, 558, 571, 572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 605};
    protected static final String CONTACT_URL = "/ajax/contacts";
    protected static int contactFolderId = -1;
    protected long dateTime = 0L;
    protected int userId = 0;
    private static final Log LOG = LogFactory.getLog(ContactTest.class);

    public ContactTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        FolderObject folderObj = FolderTest.getStandardContactFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        contactFolderId = folderObj.getObjectID();
        this.userId = folderObj.getCreatedBy();
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.dateTime = c.getTimeInMillis();
    }

    protected int createContactWithDistributionList(String title, Contact contactEntry) throws Exception {
        Contact contactObj = new Contact();
        contactObj.setSurName(title);
        contactObj.setParentFolderID(contactFolderId);
        DistributionListEntryObject[] entry = new DistributionListEntryObject[]{new DistributionListEntryObject("displayname a", "a@a.de", 0), new DistributionListEntryObject("displayname b", "b@b.de", 0), new DistributionListEntryObject(contactEntry.getDisplayName(), contactEntry.getEmail1(), 1)};
        entry[2].setEntryID(contactEntry.getObjectID());
        contactObj.setDistributionList(entry);
        return ContactTest.insertContact(this.getWebConversation(), contactObj, "http://" + this.getHostName(), this.getSessionId());
    }

    protected int createContactWithLinks(String title, Contact link1, Contact link2) throws Exception {
        Contact contactObj = new Contact();
        contactObj.setSurName(title);
        contactObj.setParentFolderID(contactFolderId);
        LinkEntryObject[] links = new LinkEntryObject[2];
        links[0] = new LinkEntryObject();
        links[0].setLinkID(link1.getObjectID());
        links[0].setLinkDisplayname(link1.getDisplayName());
        links[1] = new LinkEntryObject();
        links[1].setLinkID(link2.getObjectID());
        links[1].setLinkDisplayname(link2.getDisplayName());
        contactObj.setLinks(links);
        return ContactTest.insertContact(this.getWebConversation(), contactObj, "http://" + this.getHostName(), this.getSessionId());
    }

    protected void compareObject(Contact contactObj1, Contact contactObj2) throws Exception {
        ContactTest.assertEquals((String)"id is not equals", (int)contactObj1.getObjectID(), (int)contactObj2.getObjectID());
        ContactTest.assertEquals((String)"folder id is not equals", (int)contactObj1.getParentFolderID(), (int)contactObj2.getParentFolderID());
        ContactTest.assertEquals((String)"private flag is not equals", (boolean)contactObj1.getPrivateFlag(), (boolean)contactObj2.getPrivateFlag());
        OXTestToolkit.assertEqualsAndNotNull("categories is not equals", contactObj1.getCategories(), contactObj2.getCategories());
        OXTestToolkit.assertEqualsAndNotNull("given name is not equals", contactObj1.getGivenName(), contactObj2.getGivenName());
        OXTestToolkit.assertEqualsAndNotNull("surname is not equals", contactObj1.getSurName(), contactObj2.getSurName());
        OXTestToolkit.assertEqualsAndNotNull("anniversary is not equals", contactObj1.getAnniversary(), contactObj2.getAnniversary());
        OXTestToolkit.assertEqualsAndNotNull("assistant name is not equals", contactObj1.getAssistantName(), contactObj2.getAssistantName());
        OXTestToolkit.assertEqualsAndNotNull("birthday is not equals", contactObj1.getBirthday(), contactObj2.getBirthday());
        OXTestToolkit.assertEqualsAndNotNull("branches is not equals", contactObj1.getBranches(), contactObj2.getBranches());
        OXTestToolkit.assertEqualsAndNotNull("business categorie is not equals", contactObj1.getBusinessCategory(), contactObj2.getBusinessCategory());
        OXTestToolkit.assertEqualsAndNotNull("cellular telephone1 is not equals", contactObj1.getCellularTelephone1(), contactObj2.getCellularTelephone1());
        OXTestToolkit.assertEqualsAndNotNull("cellular telephone2 is not equals", contactObj1.getCellularTelephone2(), contactObj2.getCellularTelephone2());
        OXTestToolkit.assertEqualsAndNotNull("city business is not equals", contactObj1.getCityBusiness(), contactObj2.getCityBusiness());
        OXTestToolkit.assertEqualsAndNotNull("city home is not equals", contactObj1.getCityHome(), contactObj2.getCityHome());
        OXTestToolkit.assertEqualsAndNotNull("city other is not equals", contactObj1.getCityOther(), contactObj2.getCityOther());
        OXTestToolkit.assertEqualsAndNotNull("commercial register is not equals", contactObj1.getCommercialRegister(), contactObj2.getCommercialRegister());
        OXTestToolkit.assertEqualsAndNotNull("company is not equals", contactObj1.getCompany(), contactObj2.getCompany());
        OXTestToolkit.assertEqualsAndNotNull("country business is not equals", contactObj1.getCountryBusiness(), contactObj2.getCountryBusiness());
        OXTestToolkit.assertEqualsAndNotNull("country home is not equals", contactObj1.getCountryHome(), contactObj2.getCountryHome());
        OXTestToolkit.assertEqualsAndNotNull("country other is not equals", contactObj1.getCountryOther(), contactObj2.getCountryOther());
        OXTestToolkit.assertEqualsAndNotNull("department is not equals", contactObj1.getDepartment(), contactObj2.getDepartment());
        OXTestToolkit.assertEqualsAndNotNull("display name is not equals", contactObj1.getDisplayName(), contactObj2.getDisplayName());
        OXTestToolkit.assertEqualsAndNotNull("email1 is not equals", contactObj1.getEmail1(), contactObj2.getEmail1());
        OXTestToolkit.assertEqualsAndNotNull("email2 is not equals", contactObj1.getEmail2(), contactObj2.getEmail2());
        OXTestToolkit.assertEqualsAndNotNull("email3 is not equals", contactObj1.getEmail3(), contactObj2.getEmail3());
        OXTestToolkit.assertEqualsAndNotNull("employee type is not equals", contactObj1.getEmployeeType(), contactObj2.getEmployeeType());
        OXTestToolkit.assertEqualsAndNotNull("fax business is not equals", contactObj1.getFaxBusiness(), contactObj2.getFaxBusiness());
        OXTestToolkit.assertEqualsAndNotNull("fax home is not equals", contactObj1.getFaxHome(), contactObj2.getFaxHome());
        OXTestToolkit.assertEqualsAndNotNull("fax other is not equals", contactObj1.getFaxOther(), contactObj2.getFaxOther());
        OXTestToolkit.assertEqualsAndNotNull("info is not equals", contactObj1.getInfo(), contactObj2.getInfo());
        OXTestToolkit.assertEqualsAndNotNull("instant messenger1 is not equals", contactObj1.getInstantMessenger1(), contactObj2.getInstantMessenger1());
        OXTestToolkit.assertEqualsAndNotNull("instant messenger2 is not equals", contactObj1.getInstantMessenger2(), contactObj2.getInstantMessenger2());
        OXTestToolkit.assertEqualsAndNotNull("instant messenger2 is not equals", contactObj1.getInstantMessenger2(), contactObj2.getInstantMessenger2());
        OXTestToolkit.assertEqualsAndNotNull("marital status is not equals", contactObj1.getMaritalStatus(), contactObj2.getMaritalStatus());
        OXTestToolkit.assertEqualsAndNotNull("manager name is not equals", contactObj1.getManagerName(), contactObj2.getManagerName());
        OXTestToolkit.assertEqualsAndNotNull("middle name is not equals", contactObj1.getMiddleName(), contactObj2.getMiddleName());
        OXTestToolkit.assertEqualsAndNotNull("nickname is not equals", contactObj1.getNickname(), contactObj2.getNickname());
        OXTestToolkit.assertEqualsAndNotNull("note is not equals", contactObj1.getNote(), contactObj2.getNote());
        OXTestToolkit.assertEqualsAndNotNull("number of children is not equals", contactObj1.getNumberOfChildren(), contactObj2.getNumberOfChildren());
        OXTestToolkit.assertEqualsAndNotNull("number of employee is not equals", contactObj1.getNumberOfEmployee(), contactObj2.getNumberOfEmployee());
        OXTestToolkit.assertEqualsAndNotNull("position is not equals", contactObj1.getPosition(), contactObj2.getPosition());
        OXTestToolkit.assertEqualsAndNotNull("postal code business is not equals", contactObj1.getPostalCodeBusiness(), contactObj2.getPostalCodeBusiness());
        OXTestToolkit.assertEqualsAndNotNull("postal code home is not equals", contactObj1.getPostalCodeHome(), contactObj2.getPostalCodeHome());
        OXTestToolkit.assertEqualsAndNotNull("postal code other is not equals", contactObj1.getPostalCodeOther(), contactObj2.getPostalCodeOther());
        OXTestToolkit.assertEqualsAndNotNull("profession is not equals", contactObj1.getProfession(), contactObj2.getProfession());
        OXTestToolkit.assertEqualsAndNotNull("room number is not equals", contactObj1.getRoomNumber(), contactObj2.getRoomNumber());
        OXTestToolkit.assertEqualsAndNotNull("sales volume is not equals", contactObj1.getSalesVolume(), contactObj2.getSalesVolume());
        OXTestToolkit.assertEqualsAndNotNull("spouse name is not equals", contactObj1.getSpouseName(), contactObj2.getSpouseName());
        OXTestToolkit.assertEqualsAndNotNull("state business is not equals", contactObj1.getStateBusiness(), contactObj2.getStateBusiness());
        OXTestToolkit.assertEqualsAndNotNull("state home is not equals", contactObj1.getStateHome(), contactObj2.getStateHome());
        OXTestToolkit.assertEqualsAndNotNull("state other is not equals", contactObj1.getStateOther(), contactObj2.getStateOther());
        OXTestToolkit.assertEqualsAndNotNull("street business is not equals", contactObj1.getStreetBusiness(), contactObj2.getStreetBusiness());
        OXTestToolkit.assertEqualsAndNotNull("street home is not equals", contactObj1.getStreetHome(), contactObj2.getStreetHome());
        OXTestToolkit.assertEqualsAndNotNull("street other is not equals", contactObj1.getStreetOther(), contactObj2.getStreetOther());
        OXTestToolkit.assertEqualsAndNotNull("suffix is not equals", contactObj1.getSuffix(), contactObj2.getSuffix());
        OXTestToolkit.assertEqualsAndNotNull("tax id is not equals", contactObj1.getTaxID(), contactObj2.getTaxID());
        OXTestToolkit.assertEqualsAndNotNull("telephone assistant is not equals", contactObj1.getTelephoneAssistant(), contactObj2.getTelephoneAssistant());
        OXTestToolkit.assertEqualsAndNotNull("telephone business1 is not equals", contactObj1.getTelephoneBusiness1(), contactObj2.getTelephoneBusiness1());
        OXTestToolkit.assertEqualsAndNotNull("telephone business2 is not equals", contactObj1.getTelephoneBusiness2(), contactObj2.getTelephoneBusiness2());
        OXTestToolkit.assertEqualsAndNotNull("telephone callback is not equals", contactObj1.getTelephoneCallback(), contactObj2.getTelephoneCallback());
        OXTestToolkit.assertEqualsAndNotNull("telephone car is not equals", contactObj1.getTelephoneCar(), contactObj2.getTelephoneCar());
        OXTestToolkit.assertEqualsAndNotNull("telehpone company is not equals", contactObj1.getTelephoneCompany(), contactObj2.getTelephoneCompany());
        OXTestToolkit.assertEqualsAndNotNull("telephone home1 is not equals", contactObj1.getTelephoneHome1(), contactObj2.getTelephoneHome1());
        OXTestToolkit.assertEqualsAndNotNull("telephone home2 is not equals", contactObj1.getTelephoneHome2(), contactObj2.getTelephoneHome2());
        OXTestToolkit.assertEqualsAndNotNull("telehpone ip is not equals", contactObj1.getTelephoneIP(), contactObj2.getTelephoneIP());
        OXTestToolkit.assertEqualsAndNotNull("telehpone isdn is not equals", contactObj1.getTelephoneISDN(), contactObj2.getTelephoneISDN());
        OXTestToolkit.assertEqualsAndNotNull("telephone other is not equals", contactObj1.getTelephoneOther(), contactObj2.getTelephoneOther());
        OXTestToolkit.assertEqualsAndNotNull("telephone pager is not equals", contactObj1.getTelephonePager(), contactObj2.getTelephonePager());
        OXTestToolkit.assertEqualsAndNotNull("telephone primary is not equals", contactObj1.getTelephonePrimary(), contactObj2.getTelephonePrimary());
        OXTestToolkit.assertEqualsAndNotNull("telephone radio is not equals", contactObj1.getTelephoneRadio(), contactObj2.getTelephoneRadio());
        OXTestToolkit.assertEqualsAndNotNull("telephone telex is not equals", contactObj1.getTelephoneTelex(), contactObj2.getTelephoneTelex());
        OXTestToolkit.assertEqualsAndNotNull("telephone ttytdd is not equals", contactObj1.getTelephoneTTYTTD(), contactObj2.getTelephoneTTYTTD());
        OXTestToolkit.assertEqualsAndNotNull("title is not equals", contactObj1.getTitle(), contactObj2.getTitle());
        OXTestToolkit.assertEqualsAndNotNull("url is not equals", contactObj1.getURL(), contactObj2.getURL());
        OXTestToolkit.assertEqualsAndNotNull("userfield01 is not equals", contactObj1.getUserField01(), contactObj2.getUserField01());
        OXTestToolkit.assertEqualsAndNotNull("userfield02 is not equals", contactObj1.getUserField02(), contactObj2.getUserField02());
        OXTestToolkit.assertEqualsAndNotNull("userfield03 is not equals", contactObj1.getUserField03(), contactObj2.getUserField03());
        OXTestToolkit.assertEqualsAndNotNull("userfield04 is not equals", contactObj1.getUserField04(), contactObj2.getUserField04());
        OXTestToolkit.assertEqualsAndNotNull("userfield05 is not equals", contactObj1.getUserField05(), contactObj2.getUserField05());
        OXTestToolkit.assertEqualsAndNotNull("userfield06 is not equals", contactObj1.getUserField06(), contactObj2.getUserField06());
        OXTestToolkit.assertEqualsAndNotNull("userfield07 is not equals", contactObj1.getUserField07(), contactObj2.getUserField07());
        OXTestToolkit.assertEqualsAndNotNull("userfield08 is not equals", contactObj1.getUserField08(), contactObj2.getUserField08());
        OXTestToolkit.assertEqualsAndNotNull("userfield09 is not equals", contactObj1.getUserField09(), contactObj2.getUserField09());
        OXTestToolkit.assertEqualsAndNotNull("userfield10 is not equals", contactObj1.getUserField10(), contactObj2.getUserField10());
        OXTestToolkit.assertEqualsAndNotNull("userfield11 is not equals", contactObj1.getUserField11(), contactObj2.getUserField11());
        OXTestToolkit.assertEqualsAndNotNull("userfield12 is not equals", contactObj1.getUserField12(), contactObj2.getUserField12());
        OXTestToolkit.assertEqualsAndNotNull("userfield13 is not equals", contactObj1.getUserField13(), contactObj2.getUserField13());
        OXTestToolkit.assertEqualsAndNotNull("userfield14 is not equals", contactObj1.getUserField14(), contactObj2.getUserField14());
        OXTestToolkit.assertEqualsAndNotNull("userfield15 is not equals", contactObj1.getUserField15(), contactObj2.getUserField15());
        OXTestToolkit.assertEqualsAndNotNull("userfield16 is not equals", contactObj1.getUserField16(), contactObj2.getUserField16());
        OXTestToolkit.assertEqualsAndNotNull("userfield17 is not equals", contactObj1.getUserField17(), contactObj2.getUserField17());
        OXTestToolkit.assertEqualsAndNotNull("userfield18 is not equals", contactObj1.getUserField18(), contactObj2.getUserField18());
        OXTestToolkit.assertEqualsAndNotNull("userfield19 is not equals", contactObj1.getUserField19(), contactObj2.getUserField19());
        OXTestToolkit.assertEqualsAndNotNull("userfield20 is not equals", contactObj1.getUserField20(), contactObj2.getUserField20());
        OXTestToolkit.assertEqualsAndNotNull("number of attachments is not equals", contactObj1.getNumberOfAttachments(), contactObj2.getNumberOfAttachments());
        OXTestToolkit.assertEqualsAndNotNull("default address is not equals", contactObj1.getDefaultAddress(), contactObj2.getDefaultAddress());
        OXTestToolkit.assertEqualsAndNotNull("links are not equals", this.links2String(contactObj1.getLinks()), this.links2String(contactObj2.getLinks()));
        OXTestToolkit.assertEqualsAndNotNull("distribution list is not equals", this.distributionlist2String(contactObj1.getDistributionList()), this.distributionlist2String(contactObj2.getDistributionList()));
    }

    protected Contact createContactObject(String displayname) {
        Contact contactObj = new Contact();
        contactObj.setSurName("Meier");
        contactObj.setGivenName("Herbert");
        contactObj.setStreetBusiness("Franz-Meier Weg 17");
        contactObj.setCityBusiness("Test Stadt");
        contactObj.setStateBusiness("NRW");
        contactObj.setCountryBusiness("Deutschland");
        contactObj.setTelephoneBusiness1("+49112233445566");
        contactObj.setCompany("Internal Test AG");
        contactObj.setEmail1("hebert.meier@open-xchange.com");
        contactObj.setParentFolderID(contactFolderId);
        return contactObj;
    }

    protected Contact createCompleteContactObject() throws Exception {
        Contact contactObj = new Contact();
        contactObj.setPrivateFlag(true);
        contactObj.setCategories("categories");
        contactObj.setGivenName("given name");
        contactObj.setSurName("surname");
        contactObj.setAnniversary(new Date(this.dateTime));
        contactObj.setAssistantName("assistant name");
        contactObj.setBirthday(new Date(this.dateTime));
        contactObj.setBranches("branches");
        contactObj.setBusinessCategory("business categorie");
        contactObj.setCellularTelephone1("cellular telephone1");
        contactObj.setCellularTelephone2("cellular telephone2");
        contactObj.setCityBusiness("city business");
        contactObj.setCityHome("city home");
        contactObj.setCityOther("city other");
        contactObj.setCommercialRegister("commercial register");
        contactObj.setCompany("company");
        contactObj.setCountryBusiness("country business");
        contactObj.setCountryHome("country home");
        contactObj.setCountryOther("country other");
        contactObj.setDepartment("department");
        contactObj.setDisplayName("display name");
        contactObj.setEmail1("email1@test.de");
        contactObj.setEmail2("email2@test.de");
        contactObj.setEmail3("email3@test.de");
        contactObj.setEmployeeType("employee type");
        contactObj.setFaxBusiness("fax business");
        contactObj.setFaxHome("fax home");
        contactObj.setFaxOther("fax other");
        contactObj.setInfo("info");
        contactObj.setInstantMessenger1("instant messenger1");
        contactObj.setInstantMessenger2("instant messenger2");
        contactObj.setImage1(Data.image);
        contactObj.setImageContentType("image/png");
        contactObj.setManagerName("manager name");
        contactObj.setMaritalStatus("marital status");
        contactObj.setMiddleName("middle name");
        contactObj.setNickname("nickname");
        contactObj.setNote("note");
        contactObj.setNumberOfChildren("number of children");
        contactObj.setNumberOfEmployee("number of employee");
        contactObj.setPosition("position");
        contactObj.setPostalCodeBusiness("postal code business");
        contactObj.setPostalCodeHome("postal code home");
        contactObj.setPostalCodeOther("postal code other");
        contactObj.setProfession("profession");
        contactObj.setRoomNumber("room number");
        contactObj.setSalesVolume("sales volume");
        contactObj.setSpouseName("spouse name");
        contactObj.setStateBusiness("state business");
        contactObj.setStateHome("state home");
        contactObj.setStateOther("state other");
        contactObj.setStreetBusiness("street business");
        contactObj.setStreetHome("street home");
        contactObj.setStreetOther("street other");
        contactObj.setSuffix("suffix");
        contactObj.setTaxID("tax id");
        contactObj.setTelephoneAssistant("telephone assistant");
        contactObj.setTelephoneBusiness1("telephone business1");
        contactObj.setTelephoneBusiness2("telephone business2");
        contactObj.setTelephoneCallback("telephone callback");
        contactObj.setTelephoneCar("telephone car");
        contactObj.setTelephoneCompany("telehpone company");
        contactObj.setTelephoneHome1("telephone home1");
        contactObj.setTelephoneHome2("telephone home2");
        contactObj.setTelephoneIP("telehpone ip");
        contactObj.setTelephoneISDN("telehpone isdn");
        contactObj.setTelephoneOther("telephone other");
        contactObj.setTelephonePager("telephone pager");
        contactObj.setTelephonePrimary("telephone primary");
        contactObj.setTelephoneRadio("telephone radio");
        contactObj.setTelephoneTelex("telephone telex");
        contactObj.setTelephoneTTYTTD("telephone ttytdd");
        contactObj.setTitle("title");
        contactObj.setURL("url");
        contactObj.setUserField01("userfield01");
        contactObj.setUserField02("userfield02");
        contactObj.setUserField03("userfield03");
        contactObj.setUserField04("userfield04");
        contactObj.setUserField05("userfield05");
        contactObj.setUserField06("userfield06");
        contactObj.setUserField07("userfield07");
        contactObj.setUserField08("userfield08");
        contactObj.setUserField09("userfield09");
        contactObj.setUserField10("userfield10");
        contactObj.setUserField11("userfield11");
        contactObj.setUserField12("userfield12");
        contactObj.setUserField13("userfield13");
        contactObj.setUserField14("userfield14");
        contactObj.setUserField15("userfield15");
        contactObj.setUserField16("userfield16");
        contactObj.setUserField17("userfield17");
        contactObj.setUserField18("userfield18");
        contactObj.setUserField19("userfield19");
        contactObj.setUserField20("userfield20");
        contactObj.setDefaultAddress(1);
        contactObj.setParentFolderID(contactFolderId);
        Contact link1 = this.createContactObject("link1");
        Contact link2 = this.createContactObject("link2");
        int linkId1 = ContactTest.insertContact(this.getWebConversation(), link1, "http://" + this.getHostName(), this.getSessionId());
        link1.setObjectID(linkId1);
        int linkId2 = ContactTest.insertContact(this.getWebConversation(), link2, "http://" + this.getHostName(), this.getSessionId());
        link2.setObjectID(linkId2);
        LinkEntryObject[] links = new LinkEntryObject[2];
        links[0] = new LinkEntryObject();
        links[0].setLinkID(link1.getObjectID());
        links[0].setLinkDisplayname(link1.getDisplayName());
        links[1] = new LinkEntryObject();
        links[1].setLinkID(link2.getObjectID());
        links[1].setLinkDisplayname(link2.getDisplayName());
        contactObj.setLinks(links);
        DistributionListEntryObject[] entry = new DistributionListEntryObject[]{new DistributionListEntryObject("displayname a", "a@a.de", 0), new DistributionListEntryObject(link1.getDisplayName(), link1.getEmail1(), 1)};
        entry[1].setEntryID(link1.getObjectID());
        contactObj.setDistributionList(entry);
        return contactObj;
    }

    public static int insertContact(WebConversation webCon, Contact contactObj, String host, String session) throws Exception {
        JSONObject data;
        host = ContactTest.appendPrefix(host);
        int objectId = 0;
        StringWriter stringWriter = new StringWriter();
        JSONObject jsonObj = new JSONObject();
        ContactWriter contactWriter = new ContactWriter(TimeZone.getDefault());
        contactWriter.writeContact(contactObj, jsonObj, null);
        stringWriter.write(jsonObj.toString());
        stringWriter.flush();
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "new");
        PutMethodWebRequest req = null;
        WebResponse resp = null;
        JSONObject jResponse = null;
        if (contactObj.containsImage1()) {
            PostMethodWebRequest postReq = new PostMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters(), true);
            postReq.setParameter("json", stringWriter.toString());
            File f = File.createTempFile("open-xchange_image", ".jpg");
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(contactObj.getImage1());
            fos.flush();
            fos.close();
            postReq.selectFile("file", f, "image/png");
            req = postReq;
            resp = webCon.getResource((WebRequest)req);
            f.delete();
            jResponse = ContactTest.extractFromCallback(resp.getText());
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(stringWriter.toString().getBytes(Charsets.UTF_8));
            req = new PutMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
            resp = webCon.getResponse((WebRequest)req);
            jResponse = new JSONObject(resp.getText());
        }
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)jResponse.toString());
        if (response.hasError()) {
            ContactTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        if ((data = (JSONObject)response.getData()).has("id")) {
            objectId = data.getInt("id");
        }
        return objectId;
    }

    public static void updateContact(WebConversation webCon, Contact contactObj, int objectId, int inFolder, String host, String session) throws Exception {
        host = ContactTest.appendPrefix(host);
        StringWriter stringWriter = new StringWriter();
        JSONObject jsonObj = new JSONObject();
        ContactWriter contactWriter = new ContactWriter(TimeZone.getDefault());
        contactWriter.writeContact(contactObj, jsonObj, null);
        stringWriter.write(jsonObj.toString());
        stringWriter.flush();
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "update");
        parameter.setParameter("id", Integer.toString(objectId));
        parameter.setParameter("folder", Integer.toString(inFolder));
        parameter.setParameter("timestamp", new Date(System.currentTimeMillis() + 1000000L));
        PutMethodWebRequest req = null;
        WebResponse resp = null;
        JSONObject jResponse = null;
        if (contactObj.containsImage1()) {
            PostMethodWebRequest postReq = new PostMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters(), true);
            postReq.setParameter("json", stringWriter.toString());
            File f = File.createTempFile("open-xchange_image", ".jpg");
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(contactObj.getImage1());
            fos.flush();
            fos.close();
            postReq.selectFile("file", f, "image/png");
            req = postReq;
            resp = webCon.getResource((WebRequest)req);
            f.delete();
            jResponse = ContactTest.extractFromCallback(resp.getText());
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(stringWriter.toString().getBytes(Charsets.UTF_8));
            req = new PutMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
            resp = webCon.getResponse((WebRequest)req);
            jResponse = new JSONObject(resp.getText());
        }
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)jResponse.toString());
        if (response.hasError()) {
            ContactTest.fail((String)("json error: " + response.getErrorMessage()));
        }
    }

    public static void deleteContact(WebConversation webCon, int id, int inFolder, String host, String session) throws Exception {
        host = ContactTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "delete");
        parameter.setParameter("timestamp", new Date(System.currentTimeMillis() + 1000000L));
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", id);
        jsonObj.put("folder", inFolder);
        ByteArrayInputStream bais = new ByteArrayInputStream(jsonObj.toString().getBytes());
        PutMethodWebRequest req = new PutMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            ContactTest.fail((String)("json error: " + response.getErrorMessage()));
        }
    }

    public static Contact[] listContact(WebConversation webCon, int inFolder, int[] cols, String host, String session) throws Exception {
        return ContactTest.listContact(webCon, inFolder, cols, -1, -1, host, session);
    }

    public static Contact[] listContact(WebConversation webCon, int inFolder, int[] cols, int leftHandLimit, int rightHandLimit, String host, String session) throws Exception {
        host = ContactTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "all");
        parameter.setParameter("folder", inFolder);
        parameter.setParameter("columns", URLParameter.colsArray2String(cols));
        if (leftHandLimit > -1) {
            parameter.setParameter("left_hand_limit", leftHandLimit);
        }
        if (rightHandLimit > -1) {
            parameter.setParameter("right_hand_limit", rightHandLimit);
        }
        GetMethodWebRequest req = new GetMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            ContactTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        ContactTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        return ContactTest.jsonArray2ContactArray((JSONArray)response.getData(), cols);
    }

    public static Contact[] searchContact(WebConversation webCon, String searchpattern, int inFolder, int[] cols, String host, String session) throws OXException, Exception {
        return ContactTest.searchContact(webCon, searchpattern, inFolder, cols, false, host, session);
    }

    public static Contact[] searchContact(WebConversation webCon, String searchpattern, int inFolder, int[] cols, boolean startletter, String host, String session) throws OXException, Exception {
        host = ContactTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "search");
        parameter.setParameter("columns", URLParameter.colsArray2String(cols));
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("pattern", (Object)searchpattern);
        jsonObj.put("folder", inFolder);
        jsonObj.put("startletter", startletter);
        PutMethodWebRequest req = new PutMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters(), (InputStream)new ByteArrayInputStream(jsonObj.toString().getBytes()), "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            throw new TestException(response.getErrorMessage());
        }
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        return ContactTest.jsonArray2ContactArray((JSONArray)response.getData(), cols);
    }

    public static Contact[] searchContactAdvanced(WebConversation webCon, ContactSearchObject cso, int folder, int[] cols, String host, String session) throws OXException, Exception {
        return ContactTest.searchContactAdvanced(webCon, cso, folder, 0, cols, host, session);
    }

    public static Contact[] searchContactAdvanced(WebConversation webCon, ContactSearchObject cso, int folder, int orderBy, int[] cols, String host, String session) throws OXException, Exception {
        host = ContactTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "search");
        parameter.setParameter("columns", URLParameter.colsArray2String(cols));
        if (orderBy != 0) {
            parameter.setParameter("sort", orderBy);
            parameter.setParameter("order", "ASC");
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("last_name", (Object)cso.getSurname());
        jsonObj.put("first_name", (Object)cso.getGivenName());
        jsonObj.put("display_name", (Object)cso.getDisplayName());
        jsonObj.put("email1", (Object)cso.getEmail1());
        jsonObj.put("email2", (Object)cso.getEmail2());
        jsonObj.put("email3", (Object)cso.getEmail3());
        if (cso.isEmailAutoComplete()) {
            jsonObj.put("emailAutoComplete", (Object)"true");
        }
        PutMethodWebRequest req = new PutMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters(), (InputStream)new ByteArrayInputStream(jsonObj.toString().getBytes()), "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            throw new TestException(response.getErrorMessage());
        }
        ContactTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        return ContactTest.jsonArray2ContactArray((JSONArray)response.getData(), cols);
    }

    public static Contact[] listContact(WebConversation webCon, int[][] objectIdAndFolderId, int[] cols, String host, String session) throws Exception {
        host = ContactTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "list");
        parameter.setParameter("columns", URLParameter.colsArray2String(cols));
        JSONArray jsonArray = new JSONArray();
        for (int a = 0; a < objectIdAndFolderId.length; ++a) {
            int[] i = objectIdAndFolderId[a];
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("id", i[0]);
            jsonObj.put("folder", i[1]);
            jsonArray.put((Object)jsonObj);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(jsonArray.toString().getBytes());
        PutMethodWebRequest req = new PutMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            ContactTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        ContactTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        return ContactTest.jsonArray2ContactArray((JSONArray)response.getData(), cols);
    }

    public static Contact loadUser(WebConversation webCon, int userId, String host, String session) throws OXException, IOException, SAXException, JSONException {
        return UserTools.getUserContact(webCon, host, session, userId);
    }

    public static Contact loadContact(WebConversation webCon, int objectId, int inFolder, String protocol, String host, String session) throws Exception {
        AJAXClient client = new AJAXClient(new AJAXSession(webCon, host, session), false);
        if (protocol.endsWith("://")) {
            client.setProtocol(protocol.substring(0, protocol.length() - 3));
        } else {
            client.setProtocol(protocol);
        }
        client.setHostname(host);
        TimeZone timeZone = client.getValues().getTimeZone();
        GetRequest request = new GetRequest(inFolder, objectId, timeZone);
        GetResponse response = client.execute(request);
        return response.getContact();
    }

    public static Contact loadUser(WebConversation webCon, int userId, int inFolder, String host, String session) throws Exception {
        int[] cols = new int[]{1, 2, 4, 5, 3, 20, 100, 501, 502, 555, 556, 557, 524};
        Contact[] contactArray = ContactTest.listContact(webCon, inFolder, cols, host, session);
        for (int a = 0; a < contactArray.length; ++a) {
            if (contactArray[a].getInternalUserId() != userId) continue;
            return contactArray[a];
        }
        return null;
    }

    public static byte[] loadImage(WebConversation webCon, int objectId, int inFolder, String host, String session) throws Exception {
        host = ContactTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "image");
        parameter.setParameter("id", objectId);
        parameter.setParameter("folder", inFolder);
        GetMethodWebRequest req = new GetMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        InputStream is = resp.getInputStream();
        ContactTest.assertNotNull((String)"response InputStream is null", (Object)is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int i = 0;
        while ((i = is.read(b)) != -1) {
            baos.write(b, 0, i);
        }
        return baos.toByteArray();
    }

    public static Contact[] listModifiedAppointment(WebConversation webCon, int inFolder, Date modified, String host, String session) throws Exception {
        host = ContactTest.appendPrefix(host);
        int[] cols = new int[]{1};
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "updates");
        parameter.setParameter("folder", inFolder);
        parameter.setParameter("ignore", "deleted");
        parameter.setParameter("timestamp", modified);
        parameter.setParameter("columns", URLParameter.colsArray2String(cols));
        GetMethodWebRequest req = new GetMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            ContactTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        ContactTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        return ContactTest.jsonArray2ContactArray((JSONArray)response.getData(), cols);
    }

    public static Contact[] listDeleteAppointment(WebConversation webCon, int inFolder, Date modified, String host, String session) throws Exception {
        host = ContactTest.appendPrefix(host);
        int[] cols = new int[]{1};
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "updates");
        parameter.setParameter("folder", inFolder);
        parameter.setParameter("ignore", "updated");
        parameter.setParameter("timestamp", modified);
        parameter.setParameter("columns", URLParameter.colsArray2String(cols));
        GetMethodWebRequest req = new GetMethodWebRequest(host + CONTACT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            ContactTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        ContactTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        ContactTest.assertEquals((int)200, (int)resp.getResponseCode());
        return ContactTest.jsonArray2ContactArray((JSONArray)response.getData(), cols);
    }

    private static Contact[] jsonArray2AppointmentArray(JSONArray jsonArray) throws Exception {
        Contact[] contactArray = new Contact[jsonArray.length()];
        ContactParser contactParser = new ContactParser();
        for (int a = 0; a < contactArray.length; ++a) {
            contactArray[a] = new Contact();
            JSONObject jObj = jsonArray.getJSONObject(a);
            contactParser.parse(contactArray[a], jObj);
        }
        return contactArray;
    }

    protected static Contact[] jsonArray2ContactArray(JSONArray jsonArray, int[] cols) throws Exception {
        Contact[] contactArray = new Contact[jsonArray.length()];
        for (int a = 0; a < contactArray.length; ++a) {
            contactArray[a] = new Contact();
            ContactTest.parseCols(cols, jsonArray.getJSONArray(a), contactArray[a]);
        }
        return contactArray;
    }

    private static void parseCols(int[] cols, JSONArray jsonArray, Contact contactObj) throws Exception {
        ContactTest.assertEquals((String)"compare array size with cols size", (int)cols.length, (int)jsonArray.length());
        for (int a = 0; a < cols.length; ++a) {
            ContactTest.parse(a, cols[a], jsonArray, contactObj);
        }
    }

    private static void parse(int pos, int field, JSONArray jsonArray, Contact contactObj) throws Exception {
        switch (field) {
            case 1: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setObjectID(jsonArray.getInt(pos));
                break;
            }
            case 2: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCreatedBy(jsonArray.getInt(pos));
                break;
            }
            case 4: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCreationDate(new Date(jsonArray.getLong(pos)));
                break;
            }
            case 3: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setModifiedBy(jsonArray.getInt(pos));
                break;
            }
            case 5: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setLastModified(new Date(jsonArray.getLong(pos)));
                break;
            }
            case 20: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setParentFolderID(jsonArray.getInt(pos));
                break;
            }
            case 101: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setPrivateFlag(jsonArray.getBoolean(pos));
                break;
            }
            case 502: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setSurName(jsonArray.getString(pos));
                break;
            }
            case 501: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setGivenName(jsonArray.getString(pos));
                break;
            }
            case 517: {
                if (jsonArray.isNull(pos)) break;
                String lAnniversary = jsonArray.getString(pos);
                if (lAnniversary != null && !lAnniversary.equals("null")) {
                    contactObj.setAnniversary(new Date(Long.parseLong(lAnniversary)));
                    break;
                }
                contactObj.setAnniversary(null);
                break;
            }
            case 537: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setAssistantName(jsonArray.getString(pos));
                break;
            }
            case 511: {
                if (jsonArray.isNull(pos)) break;
                String lBirthday = jsonArray.getString(pos);
                if (lBirthday != null && !lBirthday.equals("null")) {
                    contactObj.setBirthday(new Date(Long.parseLong(lBirthday)));
                    break;
                }
                contactObj.setBirthday(null);
                break;
            }
            case 533: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setBranches(jsonArray.getString(pos));
                break;
            }
            case 534: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setBusinessCategory(jsonArray.getString(pos));
                break;
            }
            case 100: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCategories(jsonArray.getString(pos));
                break;
            }
            case 551: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCellularTelephone1(jsonArray.getString(pos));
                break;
            }
            case 552: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCellularTelephone2(jsonArray.getString(pos));
                break;
            }
            case 508: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCityHome(jsonArray.getString(pos));
                break;
            }
            case 526: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCityBusiness(jsonArray.getString(pos));
                break;
            }
            case 539: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCityOther(jsonArray.getString(pos));
                break;
            }
            case 532: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCommercialRegister(jsonArray.getString(pos));
                break;
            }
            case 569: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCompany(jsonArray.getString(pos));
                break;
            }
            case 510: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCountryHome(jsonArray.getString(pos));
                break;
            }
            case 528: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCountryBusiness(jsonArray.getString(pos));
                break;
            }
            case 541: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setCountryOther(jsonArray.getString(pos));
                break;
            }
            case 519: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setDepartment(jsonArray.getString(pos));
                break;
            }
            case 605: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setDefaultAddress(jsonArray.getInt(pos));
                break;
            }
            case 500: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setDisplayName(jsonArray.getString(pos));
                break;
            }
            case 555: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setEmail1(jsonArray.getString(pos));
                break;
            }
            case 556: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setEmail2(jsonArray.getString(pos));
                break;
            }
            case 557: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setEmail3(jsonArray.getString(pos));
                break;
            }
            case 521: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setEmployeeType(jsonArray.getString(pos));
                break;
            }
            case 544: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setFaxBusiness(jsonArray.getString(pos));
                break;
            }
            case 550: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setFaxHome(jsonArray.getString(pos));
                break;
            }
            case 554: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setFaxOther(jsonArray.getString(pos));
                break;
            }
            case 570: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setImage1(jsonArray.getString(pos).getBytes());
                break;
            }
            case 535: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setInfo(jsonArray.getString(pos));
                break;
            }
            case 565: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setInstantMessenger1(jsonArray.getString(pos));
                break;
            }
            case 566: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setInstantMessenger2(jsonArray.getString(pos));
                break;
            }
            case 524: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setInternalUserId(jsonArray.getInt(pos));
                break;
            }
            case 102: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setLabel(jsonArray.getInt(pos));
                break;
            }
            case 536: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setManagerName(jsonArray.getString(pos));
                break;
            }
            case 512: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setMaritalStatus(jsonArray.getString(pos));
                break;
            }
            case 503: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setMiddleName(jsonArray.getString(pos));
                break;
            }
            case 515: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setNickname(jsonArray.getString(pos));
                break;
            }
            case 518: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setNote(jsonArray.getString(pos));
                break;
            }
            case 513: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setNumberOfChildren(jsonArray.getString(pos));
                break;
            }
            case 529: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setNumberOfEmployee(jsonArray.getString(pos));
                break;
            }
            case 520: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setPosition(jsonArray.getString(pos));
                break;
            }
            case 507: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setPostalCodeHome(jsonArray.getString(pos));
                break;
            }
            case 525: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setPostalCodeBusiness(jsonArray.getString(pos));
                break;
            }
            case 540: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setPostalCodeOther(jsonArray.getString(pos));
                break;
            }
            case 514: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setProfession(jsonArray.getString(pos));
                break;
            }
            case 522: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setRoomNumber(jsonArray.getString(pos));
                break;
            }
            case 530: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setSalesVolume(jsonArray.getString(pos));
                break;
            }
            case 516: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setSpouseName(jsonArray.getString(pos));
                break;
            }
            case 509: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setStateHome(jsonArray.getString(pos));
                break;
            }
            case 527: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setStateBusiness(jsonArray.getString(pos));
                break;
            }
            case 598: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setStateOther(jsonArray.getString(pos));
                break;
            }
            case 506: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setStreetHome(jsonArray.getString(pos));
                break;
            }
            case 523: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setStreetBusiness(jsonArray.getString(pos));
                break;
            }
            case 538: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setStreetOther(jsonArray.getString(pos));
                break;
            }
            case 504: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setSuffix(jsonArray.getString(pos));
                break;
            }
            case 531: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTaxID(jsonArray.getString(pos));
                break;
            }
            case 568: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneAssistant(jsonArray.getString(pos));
                break;
            }
            case 542: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneBusiness1(jsonArray.getString(pos));
                break;
            }
            case 543: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneBusiness2(jsonArray.getString(pos));
                break;
            }
            case 545: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneCallback(jsonArray.getString(pos));
                break;
            }
            case 546: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneCar(jsonArray.getString(pos));
                break;
            }
            case 547: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneCompany(jsonArray.getString(pos));
                break;
            }
            case 548: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneHome1(jsonArray.getString(pos));
                break;
            }
            case 549: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneHome2(jsonArray.getString(pos));
                break;
            }
            case 567: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneIP(jsonArray.getString(pos));
                break;
            }
            case 559: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneISDN(jsonArray.getString(pos));
                break;
            }
            case 553: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneOther(jsonArray.getString(pos));
                break;
            }
            case 560: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephonePager(jsonArray.getString(pos));
                break;
            }
            case 561: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephonePrimary(jsonArray.getString(pos));
                break;
            }
            case 562: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneRadio(jsonArray.getString(pos));
                break;
            }
            case 563: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneTelex(jsonArray.getString(pos));
                break;
            }
            case 564: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTelephoneTTYTTD(jsonArray.getString(pos));
                break;
            }
            case 505: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setTitle(jsonArray.getString(pos));
                break;
            }
            case 558: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setURL(jsonArray.getString(pos));
                break;
            }
            case 571: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField01(jsonArray.getString(pos));
                break;
            }
            case 572: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField02(jsonArray.getString(pos));
                break;
            }
            case 573: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField03(jsonArray.getString(pos));
                break;
            }
            case 574: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField04(jsonArray.getString(pos));
                break;
            }
            case 575: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField05(jsonArray.getString(pos));
                break;
            }
            case 576: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField06(jsonArray.getString(pos));
                break;
            }
            case 577: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField07(jsonArray.getString(pos));
                break;
            }
            case 578: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField08(jsonArray.getString(pos));
                break;
            }
            case 579: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField09(jsonArray.getString(pos));
                break;
            }
            case 580: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField10(jsonArray.getString(pos));
                break;
            }
            case 581: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField11(jsonArray.getString(pos));
                break;
            }
            case 582: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField12(jsonArray.getString(pos));
                break;
            }
            case 583: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField13(jsonArray.getString(pos));
                break;
            }
            case 584: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField14(jsonArray.getString(pos));
                break;
            }
            case 585: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField15(jsonArray.getString(pos));
                break;
            }
            case 586: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField16(jsonArray.getString(pos));
                break;
            }
            case 587: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField17(jsonArray.getString(pos));
                break;
            }
            case 588: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField18(jsonArray.getString(pos));
                break;
            }
            case 589: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField19(jsonArray.getString(pos));
                break;
            }
            case 590: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUserField20(jsonArray.getString(pos));
                break;
            }
            case 591: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setLinks(ContactTest.parseLinks(contactObj, jsonArray.getJSONArray(pos)));
                break;
            }
            case 592: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setDistributionList(ContactTest.parseDistributionList(contactObj, jsonArray.getJSONArray(pos)));
                break;
            }
            case 608: {
                if (jsonArray.isNull(pos)) break;
                contactObj.setUseCount(jsonArray.getInt(pos));
                break;
            }
            default: {
                throw new Exception("missing field in mapping: " + field);
            }
        }
    }

    private static LinkEntryObject[] parseLinks(Contact contactObj, JSONArray jsonArray) throws Exception {
        LinkEntryObject[] links = new LinkEntryObject[jsonArray.length()];
        for (int a = 0; a < links.length; ++a) {
            links[a] = new LinkEntryObject();
            JSONObject entry = jsonArray.getJSONObject(a);
            if (entry.has("id")) {
                links[a].setLinkID(DataParser.parseInt((JSONObject)entry, (String)"id"));
            }
            links[a].setLinkDisplayname(DataParser.parseString((JSONObject)entry, (String)"display_name"));
        }
        return links;
    }

    private static DistributionListEntryObject[] parseDistributionList(Contact contactObj, JSONArray jsonArray) throws Exception {
        DistributionListEntryObject[] distributionlist = new DistributionListEntryObject[jsonArray.length()];
        for (int a = 0; a < jsonArray.length(); ++a) {
            JSONObject entry = jsonArray.getJSONObject(a);
            distributionlist[a] = new DistributionListEntryObject();
            if (entry.has("id")) {
                distributionlist[a].setEntryID(DataParser.parseInt((JSONObject)entry, (String)"id"));
            }
            if (entry.has("first_name")) {
                distributionlist[a].setFirstname(DataParser.parseString((JSONObject)entry, (String)"first_name"));
            }
            if (entry.has("last_name")) {
                distributionlist[a].setLastname(DataParser.parseString((JSONObject)entry, (String)"last_name"));
            }
            distributionlist[a].setDisplayname(DataParser.parseString((JSONObject)entry, (String)"display_name"));
            distributionlist[a].setEmailaddress(DataParser.parseString((JSONObject)entry, (String)"mail"));
            distributionlist[a].setEmailfield(DataParser.parseInt((JSONObject)entry, (String)"mail_field"));
        }
        return distributionlist;
    }

    private HashSet links2String(LinkEntryObject[] linkEntryObject) throws Exception {
        if (linkEntryObject == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        for (int a = 0; a < linkEntryObject.length; ++a) {
            hs.add(this.link2String(linkEntryObject[a]));
        }
        return hs;
    }

    private String link2String(LinkEntryObject linkEntryObject) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("ID" + linkEntryObject.getLinkID());
        sb.append("DISPLAYNAME" + linkEntryObject.getLinkDisplayname());
        return sb.toString();
    }

    private HashSet distributionlist2String(DistributionListEntryObject[] distributionListEntry) throws Exception {
        if (distributionListEntry == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        for (int a = 0; a < distributionListEntry.length; ++a) {
            hs.add(this.entry2String(distributionListEntry[a]));
        }
        return hs;
    }

    private String entry2String(DistributionListEntryObject entry) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("ID" + entry.getEntryID());
        sb.append("D" + entry.getDisplayname());
        sb.append("F" + entry.getEmailfield());
        sb.append("E" + entry.getEmailaddress());
        return sb.toString();
    }
}

