/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log.internal;

import com.openexchange.log.LogProperties;
import com.openexchange.log.Loggable;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public final class LoggableImpl
implements Loggable {
    private final Loggable.Level level;
    private final Log log;
    private final Object message;
    private final Throwable throwable;
    private final Throwable callerTrace;
    private final Map<LogProperties.Name, Object> properties;

    public LoggableImpl(Loggable.Level level, Log log, Object message, Throwable throwable, Throwable callerTrace) {
        this.level = level;
        this.log = log;
        this.message = message;
        this.throwable = throwable;
        this.callerTrace = callerTrace;
        this.properties = new EnumMap<LogProperties.Name, Object>(LogProperties.Name.class);
    }

    public Map<LogProperties.Name, Object> properties() {
        return this.properties;
    }

    public LoggableImpl putProperties(Map<LogProperties.Name, Object> properties) {
        if (null != properties) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public Loggable.Level getLevel() {
        return this.level;
    }

    public Log getLog() {
        return this.log;
    }

    public Object getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public StackTraceElement[] getCallerTrace() {
        return this.callerTrace.getStackTrace();
    }

    public boolean isLoggable() {
        return null != this.message || null != this.throwable;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("LoggableImpl [");
        if (this.level != null) {
            builder.append("level=").append(this.level).append(", ");
        }
        if (this.log != null) {
            builder.append("log=").append(this.log).append(", ");
        }
        if (this.message != null) {
            builder.append("message=\"").append(this.message).append("\", ");
        }
        if (this.throwable != null) {
            builder.append("throwable=").append("<available>").append(", ");
        }
        if (this.callerTrace != null) {
            builder.append("callerTrace=").append("<available>");
        }
        builder.append(']');
        return builder.toString();
    }
}

