/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.subscribe.TargetFolderSession;
import com.openexchange.subscribe.helpers.DocumentMetadataHolder;
import com.openexchange.subscribe.helpers.HTTPToolkit;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.user.UserService;
import com.openexchange.userconf.UserPermissionService;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;

public class DocumentMetadataHolderFolderUpdaterStrategy
implements FolderUpdaterStrategy<DocumentMetadataHolder> {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DocumentMetadataHolderFolderUpdaterStrategy.class));
    private final UserService users;
    private final UserPermissionService userPermissions;
    private final InfostoreFacade infostore;

    public DocumentMetadataHolderFolderUpdaterStrategy(UserService users, UserPermissionService userPermissions, InfostoreFacade infostore) {
        this.users = users;
        this.userPermissions = userPermissions;
        this.infostore = infostore;
    }

    @Override
    public int calculateSimilarityScore(DocumentMetadataHolder original, DocumentMetadataHolder candidate, Object session) throws OXException {
        int score = 0;
        DocumentMetadata dm1 = original.documentMetadata;
        DocumentMetadata dm2 = candidate.documentMetadata;
        if (this.isSame(dm1.getTitle(), dm2.getTitle())) {
            score += 3;
        }
        if (this.isSame(dm1.getFileName(), dm2.getFileName())) {
            score += 3;
        }
        return score;
    }

    private boolean isSame(String s1, String s2) {
        if (null == s1) {
            return null == s2;
        }
        return s1.equals(s2);
    }

    @Override
    public void closeSession(Object session) throws OXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DocumentMetadataHolder> getData(TargetFolderDefinition target, Object session) throws OXException {
        ArrayList<DocumentMetadataHolder> list = new ArrayList<DocumentMetadataHolder>();
        InfostoreSession sess = (InfostoreSession)session;
        SearchIterator documents = this.infostore.getDocuments((long)target.getFolderIdAsInt(), target.getContext(), sess.user, sess.userConfig).results();
        try {
            while (documents.hasNext()) {
                list.add(new DocumentMetadataHolder(null, (DocumentMetadata)documents.next()));
            }
        }
        finally {
            documents.close();
        }
        return list;
    }

    @Override
    public int getThreshold(Object session) throws OXException {
        return 2;
    }

    @Override
    public boolean handles(FolderObject folder) {
        return 8 == folder.getModule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(DocumentMetadataHolder newElement, Object session) throws OXException {
        InfostoreSession sess = (InfostoreSession)session;
        InputStream file = DocumentMetadataHolderFolderUpdaterStrategy.grabFile(newElement);
        newElement.documentMetadata.setId(-1);
        newElement.documentMetadata.setFolderId((long)sess.folderId);
        newElement.documentMetadata.setVersion(-1);
        if (file == null) {
            this.infostore.saveDocumentMetadata(newElement.documentMetadata, -1L, sess.serverSession);
        } else {
            try {
                this.infostore.saveDocument(newElement.documentMetadata, file, -1L, sess.serverSession);
            }
            finally {
                Streams.close((Closeable)file);
            }
        }
    }

    private static InputStream grabFile(DocumentMetadataHolder newElement) {
        String dataLink = newElement.dataLink;
        if (dataLink == null) {
            return null;
        }
        try {
            return HTTPToolkit.grabStream(dataLink, false);
        }
        catch (IOException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Object startSession(TargetFolderDefinition target) throws OXException {
        return new InfostoreSession(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(DocumentMetadataHolder original, DocumentMetadataHolder update, Object session) throws OXException {
        if (null != update.documentMetadata.getLastModified() && original.documentMetadata.getLastModified().after(update.documentMetadata.getLastModified())) {
            return;
        }
        InfostoreSession sess = (InfostoreSession)session;
        InputStream file = DocumentMetadataHolderFolderUpdaterStrategy.grabFile(update);
        update.documentMetadata.setId(original.documentMetadata.getId());
        update.documentMetadata.setFolderId((long)sess.folderId);
        update.documentMetadata.setVersion(-1);
        if (file == null) {
            this.infostore.saveDocumentMetadata(update.documentMetadata, original.documentMetadata.getSequenceNumber(), sess.serverSession);
        } else {
            try {
                this.infostore.saveDocument(update.documentMetadata, file, original.documentMetadata.getSequenceNumber(), sess.serverSession);
            }
            finally {
                try {
                    file.close();
                }
                catch (IOException e) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private class InfostoreSession {
        public int folderId;
        public User user;
        public UserPermissionBits userConfig;
        public ServerSession serverSession;

        public InfostoreSession(TargetFolderDefinition target) throws OXException, OXException, OXException {
            this.user = DocumentMetadataHolderFolderUpdaterStrategy.this.users.getUser(target.getUserId(), target.getContext());
            this.userConfig = DocumentMetadataHolderFolderUpdaterStrategy.this.userPermissions.getUserPermissionBits(target.getUserId(), target.getContext());
            this.serverSession = new ServerSessionAdapter((Session)new TargetFolderSession(target), target.getContext(), this.user);
            this.folderId = target.getFolderIdAsInt();
        }
    }
}

