/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.calendar.CalendarSql;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.groupware.search.Order;
import com.openexchange.session.Session;
import com.openexchange.subscribe.TargetFolderSession;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import com.openexchange.tools.iterator.SearchIterator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CalendarFolderUpdaterStrategy
implements FolderUpdaterStrategy<CalendarDataObject> {
    private static final int SQL_INTERFACE = 1;
    private static final int TARGET = 2;
    private static final int[] COMPARISON_COLUMNS = new int[]{1, 20, 200, 201, 202, 223, 203, 5, 225};

    @Override
    public int calculateSimilarityScore(CalendarDataObject original, CalendarDataObject candidate, Object session) throws OXException {
        int score = 0;
        String candidatesUID = this.getPrefixForUID(original) + candidate.getUid();
        if ((this.isset(original.getUid()) || this.isset(candidate.getUid())) && this.eq(original.getUid(), candidatesUID)) {
            score += 10;
        }
        if ((this.isset(original.getTitle()) || this.isset(candidate.getTitle())) && this.eq(original.getTitle(), candidate.getTitle())) {
            score += 5;
        }
        if ((this.isset(original.getNote()) || this.isset(candidate.getNote())) && this.eq(original.getNote(), candidate.getNote())) {
            score += 3;
        }
        if (original.getStartDate() != null && candidate.getStartDate() != null && this.eq(original.getStartDate(), candidate.getStartDate())) {
            score += 3;
        }
        if (original.getEndDate() != null && candidate.getEndDate() != null && this.eq(original.getEndDate(), candidate.getEndDate())) {
            score += 3;
        }
        return score;
    }

    private boolean isset(String s) {
        return s == null || s.length() > 0;
    }

    protected boolean eq(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public void closeSession(Object session) throws OXException {
    }

    @Override
    public Collection<CalendarDataObject> getData(TargetFolderDefinition target, Object session) throws OXException {
        CalendarSql calendarSql = (CalendarSql)this.getFromSession(1, session);
        int folderId = target.getFolderIdAsInt();
        Date startDate = new Date(0L);
        Date endDate = new Date(Long.MAX_VALUE);
        ArrayList<CalendarDataObject> retval = new ArrayList<CalendarDataObject>();
        try {
            SearchIterator appointmentsInFolder = calendarSql.getAppointmentsBetweenInFolder(folderId, COMPARISON_COLUMNS, startDate, endDate, 0, Order.ASCENDING);
            while (appointmentsInFolder.hasNext()) {
                retval.add((CalendarDataObject)appointmentsInFolder.next());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retval;
    }

    @Override
    public int getThreshold(Object session) throws OXException {
        return 9;
    }

    @Override
    public boolean handles(FolderObject folder) {
        return folder.getModule() == 2;
    }

    @Override
    public void save(CalendarDataObject newElement, Object session) throws OXException {
        CalendarSql calendarSql = (CalendarSql)this.getFromSession(1, session);
        TargetFolderDefinition target = (TargetFolderDefinition)this.getFromSession(2, session);
        newElement.setParentFolderID(target.getFolderIdAsInt());
        newElement.setContext(target.getContext());
        this.addPrefixToUID(newElement);
        calendarSql.insertAppointmentObject(newElement);
    }

    private Object getFromSession(int key, Object session) {
        return ((Map)session).get(key);
    }

    @Override
    public Object startSession(TargetFolderDefinition target) throws OXException {
        HashMap<Integer, Object> userInfo = new HashMap<Integer, Object>();
        CalendarSql calendarSql = new CalendarSql((Session)new TargetFolderSession(target));
        userInfo.put(1, calendarSql);
        userInfo.put(2, target);
        try {
            calendarSql.deleteAppointmentsInFolder(target.getFolderIdAsInt());
        }
        catch (SQLException e) {
            // empty catch block
        }
        return userInfo;
    }

    @Override
    public void update(CalendarDataObject original, CalendarDataObject update, Object session) throws OXException {
        CalendarSql calendarSql = (CalendarSql)this.getFromSession(1, session);
        update.setParentFolderID(original.getParentFolderID());
        update.setObjectID(original.getObjectID());
        update.setLastModified(original.getLastModified());
        update.setContext(original.getContext());
        this.addPrefixToUID(update);
        calendarSql.updateAppointmentObject(update, original.getParentFolderID(), original.getLastModified());
    }

    private void addPrefixToUID(CalendarDataObject cdo) {
        cdo.setUid(this.getPrefixForUID(cdo) + cdo.getUid());
    }

    private String getPrefixForUID(CalendarDataObject cdo) {
        if (null != cdo.getUid() && !cdo.getUid().equals("")) {
            return Integer.toString(cdo.getContextID() + cdo.getParentFolderID());
        }
        return "";
    }
}

