/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.server.ServiceLookup;
import com.openexchange.smtp.SMTPProvider;
import com.openexchange.smtp.osgi.MailcapServiceTracker;
import com.openexchange.smtp.services.Services;
import com.openexchange.threadpool.ThreadPoolService;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.activation.MailcapCommandMap;

public final class SMTPActivator
extends HousekeepingActivator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(SMTPActivator.class));

    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class, MailAccountStorageService.class, ConfigViewFactory.class, ThreadPoolService.class};
    }

    protected void handleUnavailability(Class<?> clazz) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Absent service: " + clazz.getName()));
        }
    }

    protected void handleAvailability(Class<?> clazz) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Re-available service: " + clazz.getName()));
        }
    }

    public void startBundle() throws Exception {
        try {
            Services.setServiceLookup((ServiceLookup)this);
            this.trackService(HostnameService.class);
            this.track(MailcapCommandMap.class, new MailcapServiceTracker(this.context));
            this.openTrackers();
            Hashtable<String, String> dictionary = new Hashtable<String, String>(1);
            ((Dictionary)dictionary).put("protocol", SMTPProvider.PROTOCOL_SMTP.toString());
            this.registerService(TransportProvider.class, (Object)SMTPProvider.getInstance(), dictionary);
        }
        catch (Throwable t) {
            LOG.error((Object)t.getMessage(), t);
            throw t instanceof Exception ? (Exception)t : new Exception(t);
        }
    }

    public void stopBundle() throws Exception {
        try {
            this.cleanUp();
            Services.setServiceLookup(null);
        }
        catch (Throwable t) {
            LOG.error((Object)t.getMessage(), t);
            throw t instanceof Exception ? (Exception)t : new Exception(t);
        }
    }
}

