/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.config;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.api.AbstractProtocolProperties;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.smtp.services.Services;
import java.nio.charset.Charset;

public final class SMTPProperties
extends AbstractProtocolProperties
implements ISMTPProperties {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(SMTPProperties.class));
    private static final SMTPProperties instance = new SMTPProperties();
    private final ITransportProperties transportProperties = TransportProperties.getInstance();
    private String smtpLocalhost;
    private boolean smtpAuth;
    private boolean smtpEnvelopeFrom;
    private String smtpAuthEnc;
    private int smtpTimeout;
    private int smtpConnectionTimeout;

    public static SMTPProperties getInstance() {
        return instance;
    }

    private SMTPProperties() {
    }

    protected void loadProperties0() throws OXException {
        StringBuilder logBuilder = new StringBuilder(1024);
        logBuilder.append("\nLoading global SMTP properties...\n");
        ConfigurationService configuration = Services.getService(ConfigurationService.class);
        String smtpLocalhostStr = configuration.getProperty("com.openexchange.smtp.smtpLocalhost").trim();
        this.smtpLocalhost = smtpLocalhostStr == null || smtpLocalhostStr.length() == 0 || "null".equalsIgnoreCase(smtpLocalhostStr) ? null : smtpLocalhostStr;
        logBuilder.append("\tSMTP Localhost: ").append(this.smtpLocalhost).append('\n');
        String smtpAuthStr = configuration.getProperty("com.openexchange.smtp.smtpAuthentication", "false").trim();
        this.smtpAuth = Boolean.parseBoolean(smtpAuthStr);
        logBuilder.append("\tSMTP Authentication: ").append(this.smtpAuth).append('\n');
        String smtpEnvFromStr = configuration.getProperty("com.openexchange.smtp.setSMTPEnvelopeFrom", "false").trim();
        this.smtpEnvelopeFrom = Boolean.parseBoolean(smtpEnvFromStr);
        logBuilder.append("\tSet SMTP ENVELOPE-FROM: ").append(this.smtpEnvelopeFrom).append('\n');
        String smtpAuthEncStr = configuration.getProperty("com.openexchange.smtp.smtpAuthEnc", "UTF-8").trim();
        if (Charset.isSupported(smtpAuthEncStr)) {
            this.smtpAuthEnc = smtpAuthEncStr;
            logBuilder.append("\tSMTP Auth Encoding: ").append(this.smtpAuthEnc).append('\n');
        } else {
            this.smtpAuthEnc = "UTF-8";
            logBuilder.append("\tSMTP Auth Encoding: Unsupported charset \"").append(smtpAuthEncStr).append("\". Setting to fallback ").append(this.smtpEnvelopeFrom).append('\n');
        }
        String smtpTimeoutStr = configuration.getProperty("com.openexchange.smtp.smtpTimeout", "5000").trim();
        try {
            this.smtpTimeout = Integer.parseInt(smtpTimeoutStr);
            logBuilder.append("\tSMTP Timeout: ").append(this.smtpTimeout).append('\n');
        }
        catch (NumberFormatException e) {
            this.smtpTimeout = 5000;
            logBuilder.append("\tSMTP Timeout: Invalid value \"").append(smtpTimeoutStr).append("\". Setting to fallback ").append(this.smtpTimeout).append('\n');
        }
        String smtpConTimeoutStr = configuration.getProperty("com.openexchange.smtp.smtpConnectionTimeout", "10000").trim();
        try {
            this.smtpConnectionTimeout = Integer.parseInt(smtpConTimeoutStr);
            logBuilder.append("\tSMTP Connection Timeout: ").append(this.smtpConnectionTimeout).append('\n');
        }
        catch (NumberFormatException e) {
            this.smtpConnectionTimeout = 10000;
            logBuilder.append("\tSMTP Connection Timeout: Invalid value \"").append(smtpConTimeoutStr).append("\". Setting to fallback ").append(this.smtpConnectionTimeout).append('\n');
        }
        logBuilder.append("Global SMTP properties successfully loaded!");
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)logBuilder.toString());
        }
    }

    protected void resetFields() {
        this.smtpLocalhost = null;
        this.smtpAuth = false;
        this.smtpEnvelopeFrom = false;
        this.smtpAuthEnc = null;
        this.smtpTimeout = 0;
        this.smtpConnectionTimeout = 0;
    }

    @Override
    public String getSmtpLocalhost() {
        return this.smtpLocalhost;
    }

    @Override
    public boolean isSmtpAuth() {
        return this.smtpAuth;
    }

    @Override
    public boolean isSmtpEnvelopeFrom() {
        return this.smtpEnvelopeFrom;
    }

    @Override
    public String getSmtpAuthEnc() {
        return this.smtpAuthEnc;
    }

    @Override
    public int getSmtpTimeout() {
        return this.smtpTimeout;
    }

    @Override
    public int getSmtpConnectionTimeout() {
        return this.smtpConnectionTimeout;
    }

    public int getReferencedPartLimit() {
        return this.transportProperties.getReferencedPartLimit();
    }
}

