/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.config;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.transport.config.MailAccountTransportProperties;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.smtp.config.SMTPProperties;
import java.nio.charset.Charset;

public final class MailAccountSMTPProperties
extends MailAccountTransportProperties
implements ISMTPProperties {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailAccountSMTPProperties.class));
    private final MailAccount mailAccount;

    public MailAccountSMTPProperties(MailAccount mailAccount) {
        super(mailAccount);
        this.mailAccount = mailAccount;
    }

    @Override
    public String getSmtpAuthEnc() {
        String smtpAuthEncStr = (String)this.properties.get("com.openexchange.smtp.smtpAuthEnc");
        if (null == smtpAuthEncStr) {
            return SMTPProperties.getInstance().getSmtpAuthEnc();
        }
        if (Charset.isSupported(smtpAuthEncStr)) {
            return smtpAuthEncStr;
        }
        String fallback = SMTPProperties.getInstance().getSmtpAuthEnc();
        LOG.error((Object)new StringBuilder(64).append("SMTP Auth Encoding: Unsupported charset \"").append(smtpAuthEncStr).append("\". Setting to fallback ").append(fallback));
        return fallback;
    }

    @Override
    public int getSmtpConnectionTimeout() {
        String smtpConTimeoutStr = (String)this.properties.get("com.openexchange.smtp.smtpConnectionTimeout");
        if (null == smtpConTimeoutStr) {
            return SMTPProperties.getInstance().getSmtpConnectionTimeout();
        }
        try {
            return Integer.parseInt(smtpConTimeoutStr);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"SMTP Connection Timeout: Invalid value.", (Throwable)e);
            return SMTPProperties.getInstance().getSmtpConnectionTimeout();
        }
    }

    @Override
    public String getSmtpLocalhost() {
        String smtpLocalhostStr = (String)this.properties.get("com.openexchange.smtp.smtpLocalhost");
        if (null == smtpLocalhostStr) {
            return SMTPProperties.getInstance().getSmtpLocalhost();
        }
        return smtpLocalhostStr.length() == 0 || "null".equalsIgnoreCase(smtpLocalhostStr) ? null : smtpLocalhostStr;
    }

    @Override
    public int getSmtpTimeout() {
        String smtpTimeoutStr = (String)this.properties.get("com.openexchange.smtp.smtpTimeout");
        if (null == smtpTimeoutStr) {
            return SMTPProperties.getInstance().getSmtpTimeout();
        }
        try {
            return Integer.parseInt(smtpTimeoutStr);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"SMTP Timeout: Invalid value.", (Throwable)e);
            return SMTPProperties.getInstance().getSmtpTimeout();
        }
    }

    @Override
    public boolean isSmtpAuth() {
        String smtpAuthStr = (String)this.properties.get("com.openexchange.smtp.smtpAuthentication");
        if (null == smtpAuthStr) {
            return SMTPProperties.getInstance().isSmtpAuth();
        }
        return Boolean.parseBoolean(smtpAuthStr);
    }

    @Override
    public boolean isSmtpEnvelopeFrom() {
        boolean retval;
        if (this.mailAccount.getId() == 0) {
            String smtpEnvFromStr = (String)this.properties.get("com.openexchange.smtp.setSMTPEnvelopeFrom");
            if (null == smtpEnvFromStr) {
                return SMTPProperties.getInstance().isSmtpEnvelopeFrom();
            }
            retval = Boolean.parseBoolean(smtpEnvFromStr);
        } else {
            retval = false;
        }
        return retval;
    }
}

