/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.tools.ssl.TrustAllSSLSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.commons.logging.Log;

public final class SMTPCapabilityCache {
    static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(SMTPCapabilityCache.class));
    private static volatile ConcurrentMap<InetSocketAddress, Future<Capabilities>> MAP;

    private SMTPCapabilityCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (MAP != null) return;
        Class<SMTPCapabilityCache> clazz = SMTPCapabilityCache.class;
        synchronized (SMTPCapabilityCache.class) {
            if (MAP != null) return;
            MAP = new ConcurrentHashMap<InetSocketAddress, Future<Capabilities>>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void tearDown() {
        if (MAP == null) return;
        Class<SMTPCapabilityCache> clazz = SMTPCapabilityCache.class;
        synchronized (SMTPCapabilityCache.class) {
            if (MAP == null) return;
            SMTPCapabilityCache.clear();
            MAP = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void clear() {
        ConcurrentMap<InetSocketAddress, Future<Capabilities>> map = MAP;
        if (null != map) {
            map.clear();
        }
    }

    public static Map<String, String> getCapabilities(InetSocketAddress address, boolean isSecure, ISMTPProperties smtpProperties, String domain) throws IOException {
        return SMTPCapabilityCache.getCapabilities0(address, isSecure, smtpProperties, domain).getCapabilities();
    }

    private static Capabilities getCapabilities0(InetSocketAddress address, boolean isSecure, ISMTPProperties smtpProperties, String domain) throws IOException {
        FutureTask<Capabilities> ft;
        ConcurrentMap<InetSocketAddress, Future<Capabilities>> map = MAP;
        FutureTask<Capabilities> f = (FutureTask<Capabilities>)map.get(address);
        if (null == f && null == (f = (Future)map.putIfAbsent(address, ft = new FutureTask<Capabilities>(new CapabilityAndGreetingCallable(address, isSecure, smtpProperties, domain))))) {
            f = ft;
            ft.run();
        }
        try {
            return (Capabilities)f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e.getMessage());
        }
        catch (CancellationException e) {
            throw new IOException(e.getMessage());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw new IOException(e.getMessage());
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalStateException("Not unchecked", cause);
        }
    }

    private static final class Capabilities {
        private final Map<String, String> capabilities;

        public Capabilities(String sCapabilities) {
            String[] strings;
            HashMap<String, String> capabilities = new HashMap<String, String>(8);
            for (String cap : strings = Strings.splitByCRLF((String)sCapabilities)) {
                if (!cap.startsWith("250")) continue;
                cap = cap.substring(4);
                capabilities.put(cap.toUpperCase(Locale.US), cap);
            }
            this.capabilities = Collections.unmodifiableMap(capabilities);
        }

        public Map<String, String> getCapabilities() {
            return this.capabilities;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.capabilities == null ? 0 : ((Object)this.capabilities).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Capabilities other = (Capabilities)obj;
            return !(this.capabilities == null ? other.capabilities != null : !((Object)this.capabilities).equals(other.capabilities));
        }
    }

    private static final class CapabilityAndGreetingCallable
    implements Callable<Capabilities> {
        private final InetSocketAddress key;
        private final boolean isSecure;
        private final ISMTPProperties smtpProperties;
        private final String domain;

        public CapabilityAndGreetingCallable(InetSocketAddress key, boolean isSecure, ISMTPProperties smtpProperties, String domain) {
            this.domain = domain;
            this.key = key;
            this.isSecure = isSecure;
            this.smtpProperties = smtpProperties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Capabilities call() throws IOException {
            Socket s = null;
            try {
                s = this.isSecure ? TrustAllSSLSocketFactory.getDefault().createSocket() : new Socket();
                int connectionTimeout = this.smtpProperties.getSmtpConnectionTimeout();
                if (connectionTimeout > 0) {
                    s.connect(this.key, connectionTimeout);
                } else {
                    s.connect(this.key);
                }
                int timeout = this.smtpProperties.getSmtpTimeout();
                if (timeout > 0) {
                    s.setSoTimeout(timeout);
                }
                InputStream in = s.getInputStream();
                OutputStream out = s.getOutputStream();
                StringAllocator sb = new StringAllocator(512);
                boolean skipLF = false;
                boolean eol = false;
                int i = -1;
                while (!eol && (i = in.read()) != -1) {
                    char c = (char)i;
                    if (c == '\r') {
                        eol = true;
                        skipLF = true;
                        continue;
                    }
                    if (c == '\n') {
                        eol = true;
                        skipLF = false;
                        continue;
                    }
                    sb.append(c);
                }
                if (sb.length() > 0) {
                    sb.reinitTo(0);
                }
                if (skipLF) {
                    i = in.read();
                    skipLF = false;
                }
                String command = "EHLO " + this.domain;
                while (sb.length() == 0) {
                    int available;
                    out.write((command + "\r\n").getBytes());
                    out.flush();
                    sb.append((char)in.read());
                    while ((available = in.available()) > 0) {
                        byte[] chunk = new byte[available];
                        int read = in.read(chunk, 0, available);
                        char[] chars = new char[read];
                        for (int j = 0; j < chars.length; ++j) {
                            chars[j] = (char)(chunk[j] & 0xFF);
                        }
                        sb.append(chars, 0, read);
                    }
                    if (0 != sb.length()) continue;
                    LOG.warn((Object)("Empty EHLO response for: " + command));
                }
                String capabilities = sb.toString();
                out.write("QUIT\r\n".getBytes());
                out.flush();
                i = in.read();
                while (i != -1) {
                    i = in.read();
                }
                Capabilities capabilities2 = new Capabilities(capabilities);
                return capabilities2;
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

