/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.webdav.xml.CalendarWriter;
import java.io.OutputStream;
import java.util.Date;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class TaskWriter
extends CalendarWriter {
    protected static final int[] changeFields = new int[]{1, 2, 4, 5, 3, 20, 101, 100, 200, 201, 202, 203, 209, 220, 223, 302, 303, 204, 305, 100, 314, 312, 315, 2, 301, 309, 300, 307, 308, 313, 102, 104};
    protected static final int[] deleteFields = new int[]{1, 5};
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TaskWriter.class));

    public TaskWriter() {
    }

    public TaskWriter(User userObj, Context ctx, Session sessionObj) {
        this.userObj = userObj;
        this.ctx = ctx;
        this.sessionObj = sessionObj;
    }

    public void startWriter(int objectId, int folderId, OutputStream os) throws Exception {
        Element eProp = new Element("prop", "D", "DAV:");
        XMLOutputter xo = new XMLOutputter();
        try {
            TasksSQLImpl tasksql = new TasksSQLImpl(this.sessionObj);
            Task taskobject = tasksql.getTaskById(objectId, folderId);
            this.writeObject(taskobject, false, xo, os);
        }
        catch (OXException exc) {
            if (exc.isGeneric(OXException.Generic.NOT_FOUND)) {
                this.writeResponseElement(eProp, 0, 404, "[1001] Object not found", xo, os);
            } else {
                this.writeResponseElement(eProp, 0, 500, TaskWriter.getErrorMessage("[%s] Server Error - ", 1500), xo, os);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            this.writeResponseElement(eProp, 0, 500, TaskWriter.getErrorMessage("[%s] Server Error - ", 1500), xo, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWriter(boolean modified, boolean deleted, boolean bList, int folder_id, Date lastsync, OutputStream os) throws Exception {
        SearchIterator<Task> it;
        TasksSQLImpl tasksql = new TasksSQLImpl(this.sessionObj);
        XMLOutputter xo = new XMLOutputter();
        if (deleted) {
            it = null;
            try {
                it = tasksql.getDeletedTasksInFolder(folder_id, deleteFields, lastsync);
                this.writeIterator(it, true, xo, os);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        if (modified) {
            it = null;
            try {
                it = tasksql.getModifiedTasksInFolder(folder_id, changeFields, lastsync);
                this.writeIterator(it, false, xo, os);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        if (bList) {
            it = null;
            try {
                it = tasksql.getTaskList(folder_id, -1, -1, 0, null, deleteFields);
                this.writeList(it, xo, os);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
    }

    public void writeIterator(SearchIterator<Task> it, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        while (it.hasNext()) {
            this.writeObject((Task)it.next(), delete, xo, os);
        }
    }

    public void writeObject(Task taskObj, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        this.writeObject(taskObj, new Element("prop", "D", "DAV:"), delete, xo, os);
    }

    public void writeObject(Task taskObj, Element e_prop, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        int status = 200;
        String description = "OK";
        int object_id = 0;
        try {
            object_id = taskObj.getObjectID();
            this.addContent2PropElement(e_prop, taskObj, delete);
        }
        catch (Exception exc) {
            LOG.error((Object)"writeObject", (Throwable)exc);
            status = 500;
            description = "Server Error: " + exc.getMessage();
            object_id = 0;
        }
        this.writeResponseElement(e_prop, object_id, status, description, xo, os);
    }

    public void addContent2PropElement(Element e_prop, Task taskObj, boolean delete) throws Exception {
        if (delete) {
            TaskWriter.addElement("object_id", taskObj.getObjectID(), e_prop);
            TaskWriter.addElement("last_modified", taskObj.getLastModified(), e_prop);
            TaskWriter.addElement("object_status", "DELETE", e_prop);
        } else {
            TaskWriter.addElement("object_status", "CREATE", e_prop);
            if (taskObj.containsStartDate()) {
                TaskWriter.addElement("start_date", taskObj.getStartDate(), e_prop);
            }
            if (taskObj.containsEndDate()) {
                TaskWriter.addElement("end_date", taskObj.getEndDate(), e_prop);
            }
            if (taskObj.containsActualCosts()) {
                TaskWriter.addElement("actual_costs", taskObj.getActualCosts(), e_prop);
            }
            if (taskObj.containsActualDuration()) {
                TaskWriter.addElement("actual_duration", taskObj.getActualDuration(), e_prop);
            }
            TaskWriter.addElement("billing_information", taskObj.getBillingInformation(), e_prop);
            TaskWriter.addElement("companies", taskObj.getCompanies(), e_prop);
            if (taskObj.containsCurrency()) {
                TaskWriter.addElement("currency", taskObj.getCurrency(), e_prop);
            }
            TaskWriter.addElement("date_completed", taskObj.getDateCompleted(), e_prop);
            if (taskObj.containsPercentComplete()) {
                TaskWriter.addElement("percent_completed", taskObj.getPercentComplete(), e_prop);
            }
            if (taskObj.containsPriority()) {
                TaskWriter.addElement("priority", taskObj.getPriority(), e_prop);
            }
            if (taskObj.containsStatus()) {
                TaskWriter.addElement("status", taskObj.getStatus(), e_prop);
            }
            if (taskObj.containsTargetCosts()) {
                TaskWriter.addElement("target_costs", taskObj.getTargetCosts(), e_prop);
            }
            if (taskObj.containsTargetDuration()) {
                TaskWriter.addElement("target_duration", taskObj.getTargetDuration(), e_prop);
            }
            if (taskObj.containsTripMeter()) {
                TaskWriter.addElement("trip_meter", taskObj.getTripMeter(), e_prop);
            }
            if (taskObj.containsAlarm()) {
                TaskWriter.addElement("alarm_flag", true, e_prop);
                TaskWriter.addElement("alarm", taskObj.getAlarm(), e_prop);
            } else {
                TaskWriter.addElement("alarm_flag", false, e_prop);
            }
            this.writeCalendarElements(taskObj, e_prop);
        }
    }

    @Override
    protected int getModule() {
        return 4;
    }
}

